% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNI.R
\name{NNI}
\alias{NNI}
\alias{NNICore}
\alias{RootedNNI}
\alias{RootedNNICore}
\title{NNI}
\usage{
NNI(tree, edgeToBreak = NULL)

NNICore(parent, child, nTips = (length(parent)/2L) + 1L, edgeToBreak = NULL)

RootedNNI(tree, edgeToBreak = NULL)

RootedNNICore(parent, child, nTips = (length(parent)/2L) + 1L,
  edgeToBreak = NULL)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}}

\item{edgeToBreak}{(optional) integer specifying the index of an edge to bisect/prune, generated randomly if not specified}

\item{parent}{the first column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 1]}

\item{child}{the second column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 2]}

\item{nTips}{(optional) Number of tips.}
}
\value{
Returns a tree with class \code{phylo}.

a list containing two elements, corresponding in turn to the rearranged parent and child parameters

a list containing two elements, corresponding in turn to the rearranged parent and child parameters
}
\description{
Nearest Neighbour Interchange

Rooted NNI
}
\details{
Performs a single iteration of the nearest-neighbour interchange algorithm.
Based on the corresponding \code{phangorn} function, but re-coded to improve speed.

Branch lengths are not supported.
}
\section{Functions}{
\itemize{
\item \code{NNICore}: faster version that takes and returns parent and child parameters

\item \code{RootedNNI}: Perform \acronym{NNI} rearrangement, retaining position of root

\item \code{RootedNNICore}: faster version that takes and returns parent and child parameters
}}

\examples{
tree <- ape:::rtree(20, br=NULL)
NNI(tree)

}
\references{
The algorithm is summarized in
Felsenstein, J. 2004. \cite{Inferring Phylogenies.} Sinauer Associates, Sunderland, Massachusetts.
}
\author{
Martin R. Smith
}
