% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{SplitMatchProbability}
\alias{SplitMatchProbability}
\alias{LnSplitMatchProbability}
\title{Probability of matching this well}
\usage{
SplitMatchProbability(split1, split2)

LnSplitMatchProbability(split1, split2)
}
\arguments{
\item{split1, split2}{Logical vectors listing terminals in same order, such that
each terminal is identified as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the respective bipartition split.}
}
\value{
The proportion of permissable informative splits
splitting the terminals into bipartitions of the sizes given,
that match as well as \code{split1} and \code{split2} do.
}
\description{
Calculates the probability that two random splits of the sizes provided
will be at least as similar as the two specified.
}
\section{Functions}{
\itemize{
\item \code{LnSplitMatchProbability}: The natural logarithm of the probability
}}

\examples{
SplitMatchProbability(split1 = c(rep(TRUE, 4), rep(FALSE, 4)),
                      split2 = c(rep(TRUE, 3), rep(FALSE, 5)))
 
}
\author{
Martin R. Smith
}
