% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_second_up_recon}
\alias{mpl_second_up_recon}
\title{Finalises the ancestral state reconstructions for characters with
inapplicable values.}
\usage{
mpl_second_up_recon(node_id, left_id, right_id, anc_id, morphyobj)
}
\arguments{
\item{node_id}{The index of the node being reconstructed.}

\item{left_id}{The index of the left descendant.}

\item{right_id}{The index of the right descendant.}

\item{anc_id}{The index of the immediate ancestor of the node.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
The integral parsimony length (right now)
}
\description{
Finalises the nodal sets for any characters that may have involved
the inapplicable token and counts excess regions of applicability at nodes
having at least two descendant subtrees that possess any applicable characters.
Because this function needs to be fairly high-performance, it does not do much
checking for parameter validity, thus unsafe usage of this function might not
be caught. It is up to calling functions to ensure that the appropriate
parameters have been set before use.
}
\author{
Thomas Guillerme
}
\keyword{internal}
