% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_range.R
\name{MinimumLength}
\alias{MinimumLength}
\alias{MinimumLength.phyDat}
\alias{MinimumLength.numeric}
\alias{MinimumLength.character}
\alias{MinimumSteps}
\title{Minimum length}
\usage{
MinimumLength(x, compress = FALSE)

\method{MinimumLength}{phyDat}(x, compress = FALSE)

\method{MinimumLength}{numeric}(x, compress = NA)

\method{MinimumLength}{character}(x, compress = TRUE)

MinimumSteps(x)
}
\arguments{
\item{x}{An object of class \code{phyDat};
or a string to be coerced to a \code{phyDat} object via
\code{\link[TreeTools:PhyToString]{TreeTools::StringToPhyDat()}};
or an integer vector listing the tokens that may be present at each
tip along a single character, with each token represented as a binary digit;
e.g. a value of 11 ( = 2^0 + 2^1 + 2^3) means that
the tip may have tokens 0, 1 or 3.

Inapplicable tokens should be denoted with the integer \code{0} (not 2^0).}

\item{compress}{Logical specifying whether to retain the compression of a
\code{phyDat} object or to return a vector specifying to each individual
character, decompressed using the dataset's \code{index} attribute.}
}
\value{
\code{MinimumLength()} returns a vector of integers specifying the
minimum number of steps that each character must contain.
}
\description{
The smallest length that a character can obtain on any tree.
}
\examples{
data("inapplicable.datasets")
myPhyDat <- inapplicable.phyData[[4]]

# load your own data with
# my.PhyDat <- as.phyDat(read.nexus.data("filepath"))
# or Windows users can select a file interactively using:
# my.PhyDat <- as.phyDat(read.nexus.data(choose.files()))

class(myPhyDat) # phyDat object

# Minimum length of each character in turn
MinimumLength(myPhyDat)

# Collapse duplicate characters, per phyDat compression
MinimumLength(myPhyDat, compress = TRUE)

# Calculate length of a single character from its textual representation
MinimumLength("-{-1}{-2}{-3}2233")
}
\seealso{
Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{LengthAdded}()},
\code{\link{MorphyTreeLength}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree scoring}
