% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_attach_symbols}
\alias{mpl_attach_symbols}
\title{Attach a caller-specified list of symbols.}
\usage{
mpl_attach_symbols(symbols, morphyobj)
}
\arguments{
\item{symbols}{A C-style (i.e. NULL-terminated) string of valid state symbols.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
Morphy error code.
}
\description{
Allows the caller to specify a list of symbols in the data matrix,
otherwise, the symbols list used by Morphy will be extracted from the matrix.
The symbols list must match the symbols provided in the matrix. When Morphy
extracts symbols from the matrix, their ordering is alphanumeric, according to
their ASCII codes (i.e. "+0123...ABCD...abcd..."). Loading a user-specified
symbols list will override this ordering. Symbols loaded in either the list or
the matrix must be valid Morphy character state symbols as defined in the
statedata.h header file.  The list must end with a semicolon.
}
\seealso{
Other Morphy API functions: 
\code{\link{GapHandler}()},
\code{\link{MorphyErrorCheck}()},
\code{\link{MorphyWeights}()},
\code{\link{PhyDat2Morphy}()},
\code{\link{SingleCharMorphy}()},
\code{\link{UnloadMorphy}()},
\code{\link{is.morphyPtr}()},
\code{\link{mpl_apply_tipdata}()},
\code{\link{mpl_attach_rawdata}()},
\code{\link{mpl_delete_Morphy}()},
\code{\link{mpl_delete_rawdata}()},
\code{\link{mpl_first_down_recon}()},
\code{\link{mpl_first_up_recon}()},
\code{\link{mpl_get_charac_weight}()},
\code{\link{mpl_get_gaphandl}()},
\code{\link{mpl_get_num_charac}()},
\code{\link{mpl_get_num_internal_nodes}()},
\code{\link{mpl_get_numtaxa}()},
\code{\link{mpl_get_symbols}()},
\code{\link{mpl_init_Morphy}()},
\code{\link{mpl_new_Morphy}()},
\code{\link{mpl_second_down_recon}()},
\code{\link{mpl_second_up_recon}()},
\code{\link{mpl_set_charac_weight}()},
\code{\link{mpl_set_num_internal_nodes}()},
\code{\link{mpl_set_parsim_t}()},
\code{\link{mpl_translate_error}()},
\code{\link{mpl_update_lower_root}()},
\code{\link{mpl_update_tip}()},
\code{\link{summary.morphyPtr}()}
}
\author{
Martin Brazeau
}
\concept{Morphy API functions}
\keyword{internal}
