% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitFunctions.R
\name{Subsplit}
\alias{Subsplit}
\title{Subset of a split on fewer taxa}
\usage{
Subsplit(splits, tips, keepAll = FALSE, unique = TRUE)
}
\arguments{
\item{splits}{An object of class \code{\link[=as.Splits]{Splits}}.}

\item{tips}{A vector specifying a subset of the tip labels applied to \code{split}.}

\item{keepAll}{logical specifying whether to keep entries that define trivial
splits (i.e. splits of zero or one tip) on the subset of tips.}

\item{unique}{logical specifying whether to remove duplicate splits.}
}
\value{
An object of class \code{Splits}, defined on \code{tips}.
}
\description{
Subset of a split on fewer taxa
}
\examples{

splits <- as.Splits(PectinateTree(letters[1:9]))
efgh <- Subsplit(splits, tips = letters[5:8], keepAll = TRUE)
summary(efgh)

TrivialSplits(efgh)

Subsplit(splits, tips = letters[5:8], keepAll = FALSE)


}
\seealso{
Other split manipulation functions: 
\code{\link{TrivialSplits}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split manipulation functions}
