% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterTable.R
\name{ClusterTable}
\alias{ClusterTable}
\alias{as.ClusterTable}
\alias{as.ClusterTable.phylo}
\alias{as.ClusterTable.list}
\alias{as.ClusterTable.multiPhylo}
\title{Convert phylogenetic tree to \code{ClusterTable}}
\usage{
as.ClusterTable(x, tipLabels = NULL, ...)

\method{as.ClusterTable}{phylo}(x, tipLabels = NULL, ...)

\method{as.ClusterTable}{list}(x, tipLabels = NULL, ...)

\method{as.ClusterTable}{multiPhylo}(x, tipLabels = NULL, ...)
}
\arguments{
\item{x}{Object to convert into \code{ClusterTable}: perhaps a tree of class
\code{\link[ape:read.tree]{phylo}}.}

\item{tipLabels}{Character vector specifying sequence in which to order
tip labels.}

\item{\dots}{Presently unused.}
}
\value{
\code{as.ClusterTable()} returns an object of class \code{ClusterTable}.
}
\description{
\code{as.ClusterTable()} converts a phylogenetic tree to a \code{ClusterTable} object,
which is an internal representation of its splits suitable for rapid tree
distance calculation (per Day, 1985).
}
\details{
Each row of a cluster table relates to a clade on a tree rooted on tip 1.
Tips are numbered according to the order in which they are visited in
preorder: i.e., if plotted using \code{plot(x)}, from the top of the page
downwards.  A clade containing the tips 2 .. 5 would be denoted by the
entry \verb{2, 5}, in either row 2 or row 5 of the cluster table.
}
\examples{
tree1 <- ape::read.tree(text = "(A, (B, (C, (D, E))));");
tree2 <- ape::read.tree(text = "(A, (B, (D, (C, E))));");
ct1 <- as.ClusterTable(tree1)
summary(ct1)
as.matrix(ct1)

# Tip label order must match ct1 to allow comparison
ct2 <- as.ClusterTable(tree2, tipLabels = LETTERS[1:5])
}
\references{
\insertRef{Day1985}{TreeTools}
}
\seealso{
\link[=ClusterTable-methods]{S3 methods} for \code{ClusterTable} objects.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
