% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{Hamming}
\alias{Hamming}
\title{Hamming distance between taxa in a phylogenetic dataset}
\usage{
Hamming(
  dataset,
  ratio = TRUE,
  ambig = c("median", "mean", "zero", "one", "na", "nan")
)
}
\arguments{
\item{dataset}{Object of class \code{phyDat}.}

\item{ratio}{Logical specifying whether to weight distance against
maximum possible, given that a token that is ambiguous in either of two taxa
cannot contribute to the total distance between the pair.}

\item{ambig}{Character specifying value to return when a pair of taxa
have a zero maximum distance (perhaps due to a preponderance of ambiguous
tokens).
"median", the default, take the median of all other distance values;
"mean", the mean;
"zero" sets to zero; "one" to one;
"NA" to \code{NA_integer_}; and "NaN" to \code{NaN}.}
}
\value{
\code{Hamming()} returns an object of class \code{dist} listing the Hamming
distance between each pair of taxa.
}
\description{
The Hamming distance between a pair of taxa is the number of characters
with a different coding, i.e. the smallest number of evolutionary steps
that must have occurred since their common ancestor.
}
\details{
Tokens that contain the inapplicable state are treated as requiring no steps
to transform into any applicable token.
}
\examples{
tokens <- matrix(c(0, 0, "0", 0, "?",
                   0, 0, "1", 0, 1,
                   0, 0, "1", 0, 1,
                   0, 0, "2", 0, 1,
                   1, 1, "-", "?", 0,
                   1, 1, "2", 1, "{01}"),
                   nrow = 6, ncol = 5, byrow = TRUE,
                   dimnames = list(
                     paste0("Taxon_", LETTERS[1:6]),
                     paste0("Char_", 1:5)))

dataset <- MatrixToPhyDat(tokens)
Hamming(dataset)
}
\seealso{
Used to construct neighbour joining trees in \code{\link[=NJTree]{NJTree()}}.

\code{dist.hamming()} in the \pkg{phangorn} package provides an alternative
implementation.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
