% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriadSim_functions.R
\name{pick_target.snp}
\alias{pick_target.snp}
\title{Pick target SNPs in the pathway}
\usage{
pick_target.snp(input.plink.file, fr.desire = "double", n.snp = "integer")
}
\arguments{
\item{input.plink.file}{is a vector of two character strings for the file names of the mother's
and  father's plink base filenames with the necessary path to the directory. The plink files are in bed format and three files with 
extensions .bed .bim and .fam are expected for each parent's genotypes. In addition the allele 
frequnecy files generated by PLINK (base filename with .frq extension) are expected to be in the
same directory as the .bed file.}

\item{fr.desire}{is a double number giving the desired frequency of the target SNPs.}

\item{n.snp}{is an integer giving the number of target SNPs to be picked.}
}
\value{
The function returns a list of two: first element is  the SNPs read from the .bim file now with 
allele frequncies merged and the second is the row numbers of the target SNPs selected
among all SNPs in the .bim file.
}
\description{
The target SNPs in the pathway can be picked by users manually or use this facility function.
It helps pick the set of target SNPs in the pathway(s) based on a 
desired allele frequency. If picked manually, the target SNPs should be in the order from the smallest to the largest.
}
\examples{
m.file <- file.path(system.file(package = "TriadSim"),'extdata/pop1_4chr_mom')
f.file <- file.path(system.file(package = "TriadSim"),'extdata/pop1_4chr_dad')
picked.target <- pick_target.snp(c(m.file,f.file),0.05, 8)
cat('Target SNPs picked:',picked.target[[2]],'\\n')
}

