% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{case_control_sampling_trials}
\alias{case_control_sampling_trials}
\title{Case-control sampling of expanded data for the sequence of emulated trials}
\usage{
case_control_sampling_trials(
  data_prep,
  p_control = NULL,
  subset_condition,
  sort = FALSE
)
}
\arguments{
\item{data_prep}{Result from \code{\link[=data_preparation]{data_preparation()}}.}

\item{p_control}{Control sampling probability for selecting potential controls at each follow-up time of each trial.}

\item{subset_condition}{Expression used to \code{\link[=subset]{subset()}} the trial data before case-control sampling.}

\item{sort}{Sort data before applying case-control sampling to make sure that the resulting data are identical when
sampling from the expanded data created with \code{separate_files = TRUE} or \code{separate_files = FALSE}.}
}
\value{
A \code{data.frame} or a \code{\link[=split]{split()}} \code{data.frame} if  \code{length(p_control) > 1}. An additional column \code{sample_weight}
containing the sample weights will be added to the result. These can be included in the models fit with
\code{\link[=trial_msm]{trial_msm()}}.
}
\description{
Perform case-control sampling of expanded data to create a data set of reduced size and calculate sampling weights
to be used in \code{trial_msm()}.
}
\examples{
# If necessary reduce the number of threads for data.table
data.table::setDTthreads(2)

data("te_data_ex")
samples <- case_control_sampling_trials(te_data_ex, p_control = 0.01)
}
