% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_stm.R
\name{fit_stm}
\alias{fit_stm}
\title{Fit STM (Structural topic model)}
\usage{
fit_stm(
  data,
  n_topics = 2L,
  xcov,
  remove_punct = TRUE,
  stem = TRUE,
  remove_url = TRUE,
  remove_emojis = TRUE,
  stopwords = "en",
  ...
)
}
\arguments{
\item{data}{Data frame of parsed tweets. Obtained either by using \code{\link{load_tweets}}  or
\code{\link[jsonlite]{stream_in}} in conjunction with \code{\link[rtweet]{tweets_with_users}}.}

\item{n_topics}{Integer with number of topics.}

\item{xcov}{Either a \[stats]{formula} with an empty left-hand side specifying external covariates
(meta data) to use.e.g. \code{~favourites_count + retweet_count}
or a character vector (\code{c("favourites_count", "retweet_count")})
or comma seperated character string (\code{"favourites_count,retweet_count"})
with column names implying which metadata to use as external covariates.}

\item{remove_punct}{Logical. Indicates wheter punctuation (includes Twitter hashtags and usernames)
should be removed. Defaults to TRUE.}

\item{stem}{Logical. If \code{TRUE} turn on word stemming for terms.}

\item{remove_url}{Logical. If \code{TRUE} find and eliminate URLs beginning with http(s).}

\item{remove_emojis}{Logical. If \code{TRUE} all emojis will be removed from tweets.}

\item{stopwords}{a character vector, list of character vectors, \link[quanteda]{dictionary}
or collocations object. See \link[quanteda]{pattern} for details.
Defaults to \link[stopwords:stopwords]{stopwords("english")}.}

\item{...}{Additional arguments passed to \link[stm]{stm}.}
}
\value{
Object of class \link[stm]{stm}. Additionally, pre-processed documents are appended into a named list called "prep".
}
\description{
Estimate a structural topic model
}
\details{
Use this to function estimate a STM from a data frame of parsed Tweets.
Works with unpooled Tweets only. Pre-processing and fitting is done in one run.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# fit STM with tweets
stm_model <- fit_stm(mytweets, n_topics = 7,
                     xcov = ~ retweet_count + followers_count + reply_count +
                     quote_count + favorite_count,
                     remove_punct = TRUE,
                     remove_url = TRUE,
                     remove_emojis = TRUE,
                     stem = TRUE,
                     stopwords = "en")
}
}
\seealso{
\link[stm]{stm}
}
