% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pcawg_value.R
\name{vis_pcawg_gene_cor}
\alias{vis_pcawg_gene_cor}
\title{Visualize Gene-Gene Correlation in TCGA}
\usage{
vis_pcawg_gene_cor(
  Gene1 = "CSF1R",
  Gene2 = "JAK3",
  data_type1 = "mRNA",
  data_type2 = "mRNA",
  cor_method = "spearman",
  purity_adj = TRUE,
  use_log_x = FALSE,
  use_log_y = FALSE,
  use_regline = TRUE,
  dcc_project_code_choose = "BLCA-US",
  use_all = FALSE,
  filter_tumor = TRUE,
  alpha = 0.5,
  color = "#000000",
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene1}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Gene2}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{data_type1}{choose gene profile type for the first gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{data_type2}{choose gene profile type for the second gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{cor_method}{correlation method}

\item{purity_adj}{whether performing partial correlation adjusted by purity}

\item{use_log_x}{if \code{TRUE}, log X values.}

\item{use_log_y}{if \code{TRUE}, log Y values.}

\item{use_regline}{if \code{TRUE}, add regression line.}

\item{dcc_project_code_choose}{select project code.}

\item{use_all}{use all sample, default \code{FALSE}.}

\item{filter_tumor}{whether use tumor sample only, default \code{TRUE}}

\item{alpha}{dot alpha.}

\item{color}{dot color.}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a \code{ggplot} object
}
\description{
Visualize Gene-Gene Correlation in TCGA
}
