% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaHub-class.R
\name{XenaFilter}
\alias{XenaFilter}
\title{Filter a XenaHub Object}
\usage{
XenaFilter(x, filterCohorts = NULL, filterDatasets = NULL,
  ignore.case = TRUE)
}
\arguments{
\item{x}{a \code{XenaHub} object}

\item{filterCohorts}{default is \code{NULL}. A character used to filter cohorts,
regular expression is supported.}

\item{filterDatasets}{default is \code{NULL}. A character used to filter datasets,
regular expression is supported.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is case sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
a \code{XenaHub} object
}
\description{
Major function of \code{UCSCXenatools}. It is used to filter
\code{XenaHub} object according to cohorts, datasets. All datasets can be found
at <https://xenabrowser.net/datapages/>. Note, the change for filtering cohorts and
datasets are independent.
}
\examples{
# operate TCGA datasets
xe = XenaGenerate(subset = XenaHostNames == "TCGA")
xe
# get all names of clinical data
xe2 = XenaFilter(xe, filterDatasets = "clinical")
datasets(xe2)
}
\author{
Shixiang Wang <w_shixiang@163.com>
}
