% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{HydroPlot}
\alias{HydroPlot}
\title{Hydrological plot of concurrent discharge and precipitation}
\usage{
HydroPlot(
  x,
  Title = "Concurrent Rainfall & Discharge",
  from = NULL,
  to = NULL,
  adj.y = 1.5,
  plw = 1,
  qlw = 1.8
)
}
\arguments{
\item{x}{a data.frame with three columns in the order of date, precipitation, and discharge}

\item{Title}{a character string. The user chosen plot title. The default is "Concurrent Rainfall & Discharge"}

\item{from}{a starting time for the plot. In the form of a date or POSIXct object. The default is the first row of x}

\item{to}{an end time for the plot. In the form of a date or POSIXct object. The default is the last row of x}

\item{adj.y}{a numeric value to adjust the closeness of the preciptation and discharge in the plot. Default is 1.5. A lower value brings them closer and a larger value further apart}

\item{plw}{a numeric value to adjust the width of the precipitation lines. Default is one. A larger value thickens them and vice versa}

\item{qlw}{a numeric value to adjust the width of the discharge line. Default is 1.8. A larger value thickens them and vice versa}
}
\value{
A plot of concurrent precipitation and discharge. With the former at the top and the latter at the bottom.
}
\description{
Plots concurrent precipitation and discharge with precipitation along the top and discharge along the bottom
}
\examples{
#Plot the Thames precipitation and discharge for the 2013 hydrological year,
#adjusting the y axis to 1.8.
HydroPlot(ThamesPQ, from = "2013-10-01", to = "2014-09-30", adj.y = 1.8)
}
\author{
Anthony Hammond
}
