% Generated by roxygen2 (4.0.2): do not edit by hand
\name{kde2dForSubset}
\alias{kde2dForSubset}
\title{Compute the density based distance quantity using a 2D Kernel Density Estimation}
\usage{
kde2dForSubset(df, setw=1, n=50, showStats=TRUE, printPlots=TRUE,
returnDistance=FALSE, positionDataIndexes=c(1,2))
}
\arguments{
\item{df}{a data frame to use}

\item{setw}{an integer with the class of the stars to perform the analysis}

\item{n}{the number of points in the regular grid of the density estimation}

\item{showStats}{a boolean indicating if the user wants to see output statistics}

\item{printPlots}{a boolean indicating if the user wants to see plots}

\item{returnDistance}{a boolean indicating if the distance between the max and the mean in units of standard deviations should be returned}

\item{positionDataIndexes}{an array of integers indicating the columns of the file containing the spatial position measurements}
}
\value{
A double representing the density based distance quantity.
}
\description{
\code{kde2dForSubset} will compute the 2D Kernel Density Estimation for
the requested subset of data and will return the quantiy \code{(max(d)-mean(d))/sd(d)}
if the option \code{returnDistance} is set to TRUE.
}
\examples{
# Create a simple data set with the values and errors
toyDataDF <- data.frame(x=runif(50, 0, 10), y=runif(50, 0, 10), resMclust.class=rep(1, 50))

# Run the KDE 2D analysis for the required subset
disV <- kde2dForSubset(toyDataDF, showStats=FALSE, printPlots=FALSE, returnDistance=TRUE)

# Clean the environment
rm(list=c("toyDataDF", "disV"))
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\keyword{utilities}

