\name{DFunction}
\alias{DFunction}
\title{Generate a DFunction object for Umacs Sampler function}
\description{
Creates a \code{DFunction} object that is used to embed
an R function that performs a Gibbs updating step
for a parameter that is a \emph{deterministic function}
within the
sampler function generated by \code{\link{Sampler}}.

The main difference between \code{DFunction} and \code{\link{Gibbs}}
is that for \code{DFunction}, there is no initializing function.
Consequently it is supposed to be updated only \emph{after}
all parameter that it directly depends on are available.

The sampler is built using the Umacs function \code{\link{Sampler}};
and the argument function (\code{update}) is embedded in the sampler function.

}
\usage{
DFunction(update)
}
\arguments{
  \item{update}{ An R function (with no arguments) that samples directly from a (fully) conditional distribution May refer directly to parameters specified in the code{link{Sampler}} function call. Must return the updated value. }
}
\details{
\code{DFunction} is to be used only within the \code{Sampler} function call.

Alternatively one can just supply the function (\code{update})
in the \code{\link{Sampler}} function call;
\code{\link{Sampler}} will call \code{\link{DFunction}} for you.

The arguments of the update functions are ignored.
The body of the function can contain references to any parameters
that are defined in the \code{\link{Sampler}} function call, or to any
variables in an enclosing environment (such as the Global Environment).

The name of the parameter that is being updated \emph{not} specified here,
but only in the parameter list in the \code{\link{Sampler}} function call.

}
\value{
An object of class \code{\link{DFunction-class}}
to be further processed by the Umacs function \code{\link{Sampler}}.

}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{
\code{DFunction} \emph{must} be associated with a parameter name
(in the \code{\link{Sampler}} function call).
If you specify a plain function without a name, it will be
interpreted as an argument to a \code{\link{RawCode}} function call
and \emph{not} as an argument to \code{\link{DFunction}}.
}
\seealso{
\code{\link{Umacs-package}} for an overview of the Umacs package.

\code{\link{Sampler}} for how to create a sampler function; see the vignette for details.

Package `rv'.

}
\examples{}
\keyword{iteration}
