% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UD_bal_model.R
\name{UD_bal_model}
\alias{UD_bal_model}
\title{Model wise balanced uncertainty}
\usage{
UD_bal_model(data, var_name, stages, u = u_var, flist = flist_var)
}
\arguments{
\item{data}{a data frame containing models(factor or character) for each stages and the variable of interest(numeric).
data should contain all combinations of models.}

\item{var_name}{the name of the variable of interest}

\item{stages}{names of the stages of interest.}

\item{u}{a function that returns uncertainty of each element of the vector like difference or square of difference between each element and summary statistics.
This package have built-in uncertainty functions u_var(), u_mad() and u_range(). Default is u_var().}

\item{flist}{lists of functions that summarize vector like mean or median.
This package have built-in uncertainty functions flist_var(), flist_mad() and flist_range(). Default is flist_var().}
}
\value{
model wise uncertainties
}
\description{
This function performs the balanced uncertainty decomposition. 
In balanced uncertainty decomposition, we assume that the total uncertainty decomposes into the uncertainty of all main effects and all orders of interaction between models.
This method distributes the uncertainties of each element evenly among the associated models.
}
\examples{
set.seed(0)
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
data <- cbind(data, y)

UD_bal_model_var <- UD_bal_model(data, "y", names(data)[-4], u_var, flist_var)
UD_bal_model_var
UD_bal_model_mad <- UD_bal_model(data, "y", names(data)[-4], u_mad, flist_mad)
UD_bal_model_mad 
UD_bal_model_range <- UD_bal_model(data, "y", names(data)[-4], u_range, flist_range)
UD_bal_model_range 

UD_bal_stage_var <- UD_model2stage(UD_bal_model_var)
UD_bal_stage_var 
UD_bal_stage_mad <- UD_model2stage(UD_bal_model_mad)
UD_bal_stage_mad 
UD_bal_stage_range <- UD_model2stage(UD_bal_model_range)
UD_bal_stage_range 

UD_list = ppud(UD_bal_model_range)
plot(UD_list)

lambda = min_lambda_calc(UD_bal_model_range, 0.01)
UD_1percent = ppud(UD_bal_model_range, lambda)
UD_1percent$UD[[1]]
}
