% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-krigingUncertain.R
\docType{methods}
\name{krigingUncertain}
\alias{krigingUncertain}
\alias{krigingUncertain,Points,Spatial-method}
\alias{krigingUncertain,UncertainPoints,Spatial-method}
\title{Krigging and Fuzzy kriging interpolation}
\usage{
\S4method{krigingUncertain}{UncertainPoints,Spatial}(object, grid, data_variogram = data, block = 0, 
   model = c("Sph", "Exp", "Gau", "Ste"), kappa = c(0.05, seq(0.2, 2, 0.1), 5, 10), 
   fix.values = c(NA,NA,NA), remove_duplicates = TRUE, verbose = FALSE, GLS.model = NA, 
   start_vals = c(NA,NA,NA), miscFitOptions = list())

\S4method{krigingUncertain}{Points,Spatial}(object, grid, krigingModel, psills, ranges, nuggets, models, 
   vgm_start, logResults=FALSE)
}
\arguments{
\item{object}{Input data. An object of \code{UncertainPoints} class.}

\item{grid}{Input Spatial grid.}

\item{...}{Additional arguments to be passed to \code{f}.}

\item{data_variogram}{An optional way to provide a different dataset for the building of the variogram then for the spatial interpolation.}

\item{block}{Use this parameter to pass on a specification for the block size. e.g. c(1000,1000)}

\item{model}{List of models that will be tested during automatic variogram fitting}

\item{kappa}{List of values for the smoothing parameter of the Matern model that will be tested during automatic variogram fitting.}

\item{fix.values}{Can be used to fix a variogram parameter to a certain value. It consists of a list with a length of three. The items describe the fixed value for the nugget, range and sill respectively. Setting the value to NA means that the value is not fixed. Is passed on to autofitVariogram.}

\item{remove_duplicates}{logical, remove duplicates from input}

\item{verbose}{logical, if TRUE autoKrige will give extra information on the fitting process}

\item{GLS.model}{If a variogram model is passed on through this parameter a Generalized Least Squares sample variogram is calculated.}

\item{start_vals}{Can be used to give the starting values for the variogram fitting. The items describe the fixed value for the nugget, range and sill respectively.}

\item{miscFitOptions}{Additional options to set the behavior of autofitVariogram.}

\item{krigingModel}{Model of the kriging used in the calculations.}

\item{psills}{Defined psills.}

\item{ranges}{Defined ranges.}

\item{nuggets}{Defined nuggets.}

\item{models}{Variogram model of dependent variable (or its residuals).}

\item{vgm_start}{Modal variogram selected for the data.}

\item{logResults}{Was the dataset logaritmized prior to the calculation?}
}
\value{
Returns an object of class \code{UncertainInterpolation} or \code{FuzzyInterpolation}.
}
\description{
This function provides kriging interpolation over the input data enriched by the 
uncertainty with multiple dispatch. The input data must be an S4 object class 
of \code{UncertainPoints} or \code{Points} in case 
of Fuzzy kriging. Grid type of \code{Spatial}. Output object is type of S4 class 
\code{UncertainInterpolation} or in case of Fuzzy kriging S4 class  
\code{FuzzyInterpolation}. For more informations about fuzzy kriging 
interpolation read Details.
}
\details{
The function for Fuzzy kriging and its processes were taken from source code Jan Caha. For more informations and details visit \url{https://github.com/JanCaha/Hais2015-paper}.
}
\seealso{
\code{\link[UncerIn2]{UncertainPoints-class}}, \code{\link[UncerIn2]{Points-class}}, \code{\link[UncerIn2]{UncertainInterpolation-class}}, \code{\link[UncerIn2]{FuzzyInterpolation-class}}, \code{\link[UncerIn2]{Grid.def}},\code{\link[UncerIn2]{Grid.box}}, \code{\link[UncerIn2]{Grid.interpolation}}, \code{\link[automap]{autoKrige}}, \code{\link[UncerIn2]{Plot}}, \code{\link[UncerIn2]{uncertaintyInterpolation2-package}}, \url{https://github.com/JanCaha/Hais2015-paper}
}

