% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{break.var.local.new}
\alias{break.var.local.new}
\title{Compute local loss function.}
\usage{
break.var.local.new(
  method = "sparse",
  data,
  eta,
  q,
  max.iteration = 1000,
  tol = 10^(-4),
  pts,
  an,
  group.case = "columnwise",
  group.index = NULL
)
}
\arguments{
\item{method}{method: sparse, group sparse}

\item{data}{input data matrix, with each column representing the time series component}

\item{eta}{tuning parameter eta for lasso}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{pts}{the selected break points after the first step}

\item{an}{the neighborhood size a_n}

\item{group.case}{group sparse pattern: columnwise, rowwise.}

\item{group.index}{group index for group sparse case}
}
\value{
A list oject, which contains the followings
\describe{
  \item{L.n.1}{A vector of loss functions that include some break point}
  \item{L.n.2}{A vector of loss functions that exclude some break point}
}
}
\description{
Compute local loss function.
}
