% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{lmerSummary}
\alias{lmerSummary}
\title{Derive VCA-Summary Table from an object fitted via function \code{\link{lmer}}.}
\usage{
lmerSummary(obj, VarVC = TRUE, terms = NULL, Mean = NULL, cov = FALSE,
  X = NULL)
}
\arguments{
\item{obj}{(lmerMod) object as returned by function lmer}

\item{VarVC}{(logical) TRUE = the variance-covariance matrix of variance components will be approximated
following the Giesbrecht & Burns approach, FALSE = it will not be approximated}

\item{terms}{(character) vector, optionally defining the order of variance terms to be used}

\item{Mean}{(numeric) mean value used for CV-calculation}

\item{cov}{(logical) TRUE = in case of non-zero covariances a block diagonal matrix will be constructed,
FALSE = a diagonal matrix with all off-diagonal element being equal to zero will be contructed}

\item{X}{(matrix) design matrix of fixed effects as constructed to meet VCA-package requirements}
}
\value{
(list) still a premature 'VCA' object but close to a
}
\description{
This function builds a variance components analysis results table
from an object representing a model fitted by \code{\link{lmer}} of the
\code{lme4} R-package. It applies the approximation of the variance-covariance
matrix of variance components according to Giesbrecht & Burns (1985) and uses this
information to approximate the degrees of freedom according to Satterthwaite
(see SAS PROC MIXED documentation option 'CL').
}
\details{
This function is not intended to be called directly by users and therefore not exported.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\references{
Searle, S.R, Casella, G., McCulloch, C.E. (1992), Variance Components, Wiley New York

Giesbrecht, F.G. and Burns, J.C. (1985), Two-Stage Analysis Based on a Mixed Model: Large-Sample
Asymptotic Theory and Small-Sample Simulation Results, Biometrics 41, p. 477-486
}
\seealso{
\code{\link{remlVCA}}, \code{\link{remlMM}}
}

