\name{VonMisesParameter}
\alias{VonMisesParameter}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Calculation of von Mises concentration parameter of the azimuths}
\description{
   This function calculates the von Mises concentration parameter from a set of input azimuths.
}
\usage{
VonMisesParameter(azimuths)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{azimuths}{Vector containing the values of the azimuths}
}
\details{
   One way to obtain a set of azimuths from X and Y coordinates of the vectors is to use the \code{\link{LoadData}} function.
   
   The von Mises concentration parameter measures the departure of the distribution from the uniform distribution. If this parameter tends to 0, then the distribution converges to the uniform distribution. If it tends to infinity, then the distribution is concentrated around the mean azimuth.
}
\value{
   The von Mises concentration parameter of all input azimuths.
}
\references{
   Fisher N.I. (1995) Statistical analysis of circular data. Cambridge. Cambridge University Press.
   
    Website \url{http://gim.unex.es/VecStatGraphs2D/}
} 
\author{Ruiz-Cuetos, J.C., \email{jcruizcue@gmail.com}, Felicisimo, A.M., \email{amfeli@unex.es}, 
Cuartero, A., \email{acuartero@unex.es}, Polo, M.E., \email{mepolo@unex.es}, 
Rodriguez, P.G. \email{pablogr@unex.es}}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
   \code{\link{MeanModule}}, \code{\link{MeanAzimuth}}, \code{\link{CircularVariance}}, \code{\link{CircularStandardDeviation}},

   \code{\link{CircularDispersal}}, \code{\link{KurtosisAzimuthCoefficient}},

   \code{\link{SkewnessAzimuthCoefficient}}, \code{\link{AllAzimuthStatistics}}.
}
\examples{
   FileName<-system.file("data/RectangularData.txt", package="VecStatGraphs2D")
   dat<-LoadData(FileName, Type=2)
   azimuths<-dat[,2]
   VonMisesParameter(azimuths)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{azimuth}