% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surf.R
\name{plot_surf}
\alias{plot_surf}
\title{Surface plotter}
\usage{
plot_surf(
  surf_data,
  filename,
  title = "",
  surface = "inflated",
  cmap,
  limits,
  colorbar = TRUE,
  size,
  zoom,
  show.plot.window = TRUE,
  VWR_check = TRUE
)
}
\arguments{
\item{surf_data}{A numeric vector (length of V) or a matrix (N rows x V columns), where N is the number of subplots, and V is the number of vertices. It can be the output from SURFvextract(), FSLRvextract(), HIPvextract() as well as masks or vertex-wise results outputted by analyses functions. Alternatively, atlas ROI values as supported by atlas_to_surf() may be given.}

\item{filename}{A string object containing the desired name of the output .png. Default is 'plot.png' in the R temporary directory (tempdir()).Only filenames with a .png extension are allowed.}

\item{title}{A string object for setting the title in the plot. Default is none. For titles that too long to be fully displayed within the plot, we recommend splitting them into multiple lines by inserting "\\n".}

\item{surface}{A string object containing the name of the type of cortical surface background rendered. Possible options include "white", "smoothwm","pial" and "inflated" (default). The surface parameter is ignored for hippocampal surface data.}

\item{cmap}{A string object specifying the name of an existing colormap or a vector of hexadecimal color codes to be used as a custom colormap. The names of existing colormaps are listed in the \href{https://matplotlib.org/stable/gallery/color/colormap_reference.html}{'Matplotlib' plotting library}.

Default cmap is set to \code{"Reds"} for positive values, \code{"Blues_r"} for negative values and \code{"RdBu"} when both positive and negative values exist.}

\item{limits}{A combined pair of numeric vector composed of the lower and upper color scale limits of the plot. If the limits are specified, the same limits will be applied to all subplots. When left unspecified, the same symmetrical limits c(-max(abs(surf_dat),max(abs(surf_dat))) will be used for all subplots. If set to NULL, each subplot will have its own limits corresponding to their min and max values}

\item{colorbar}{A logical object stating whether to include a color bar in the plot or not (default is TRUE).}

\item{size}{A combined pair of numeric vector indicating the image dimensions (width and height in pixels). Default is c(1920,400) for whole-brain surface and c(400,200) for hippocampal surface.}

\item{zoom}{A numeric value for adjusting the level of zoom on the figures. Default is 1.25 for whole-brain surface and 1.20 for hippocampal surface.}

\item{show.plot.window}{A logical object to determine if the generated plot is to be shown within RStudio's plot window}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
Outputs the plot as a .png image
}
\description{
Plots surface data in a grid with one or multiple rows in a .png file
}
\examples{
results = runif(20484,min=0, max=1);
plot_surf(surf_data = results, 
filename=paste0(tempdir(),"/output.png"),
title = 'Cortical thickness', 
surface = 'inflated', cmap = 'Blues',
VWR_check=FALSE)
}
