% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exteuclid.R
\name{11. Extended Euclidean algorithm}
\alias{11. Extended Euclidean algorithm}
\alias{exteuclid}
\alias{exteuclid.default}
\alias{exteuclid.numeric}
\alias{exteuclid.vli}
\title{Extended Euclidean Algorithm for vli Objects}
\usage{
exteuclid(x, y)

\method{exteuclid}{default}(x, y)

\method{exteuclid}{numeric}(x, y)

\method{exteuclid}{vli}(x, y)
}
\arguments{
\item{x}{object of class vli or 32 bits integer}

\item{y}{object of class vli or 32 bits integer}
}
\value{
list of 3 objects of class vli: the first is the greatest common divisor of \code{x} and \code{y}, and the other two are the Bezout's coefficients
}
\description{
Computation of the Extended Euclidean algorithm for vli (Very Large Integers) objects. Given two positive integers, \code{x} and \code{y}, the Extended Euclidean algorithm looks for two integers \code{a} and \code{b} (called Bezout's coefficients) such that \code{(a * x) + (b * y) = 1}. To do this, the algorithm needs to compute the greatest common divisor of \code{x} and \code{y}, so it is also returned by the function.
}
\details{
The returned object is a list of 3 elements. To access the numbers, it is necessary to use the list operator \code{[[i]]}, where "\code{i}" has to be 1 for the greatest common divisor, 2 for the first Bezout coefficient and 3 for the second Bezout coefficient (see the example).
}
\examples{
x <- as.vli("232636113097")
y <- as.vli("52442092785616")
result <- exteuclid(x, y)
( result[[2]] * x ) + ( result[[3]] * y )
}
\author{
Javier Leiva Cuadrado
}
