% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportVirusDataFrame.R
\name{ExportVirusDataFrame}
\alias{ExportVirusDataFrame}
\title{ExportVirusDataFrame: Export processed hittables and summary stats data frames}
\usage{
ExportVirusDataFrame(
  df,
  file_name,
  dir_path = NULL,
  file_type = NULL,
  create_path = FALSE
)
}
\arguments{
\item{df}{A summary statistics or VirusHunterGatherer hittable data frame.}

\item{file_name}{A character string naming the file, optionally including ".tsv" or ".csv" file extensions.
If suffix is not provided, file_type will be used to determine the file type.}

\item{dir_path}{A character string indicating the directory path where the file will be saved (default: current corking directory).}

\item{file_type}{A character vector specifying the type of file to export. Can be "csv" or "tsv".
If NULL and file_name does not specify a suffix, the function infers the file type based on the prefix in file_name.}

\item{create_path}{Logical indicating whether to create the directory path
specified in dir_path if it does not already exist (default: FALSE).}
}
\value{
A message indicating that export was successful.
}
\description{
Export data frames generated by Virusparies functions.
}
\details{
Functions in the Virusparies package can generate both plots and new data frames.
Data frames contain either summary statistics for contig length, E-value or identity in percentage
or a processed hittable for example outlier or observations below threshold, when running
\code{\link{VhgBoxplot}}.

Both types of data frames can be exported via \code{ExportVirusDataFrame}. Summary stats and hittables
can be exported as CSV files or in TSV format, if the user prefers the file type used in VirusHunterGatherer
hittables.
}
\examples{

path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
file <- ImportVirusTable(path)


# generate a plot that returns both processed hittables (outlier) and summary stats
plot1 <- VhgBoxplot(file, x_column = "best_query", y_column = "ViralRefSeq_E")


\donttest{

# export hittable as tsv (same format as input hittables)
ExportVirusDataFrame(df=plot1$outlier,file_name="outlier",file_type="tsv",
dir_path=tempdir())

# export summary stats as csv
ExportVirusDataFrame(df=plot1$summary_stats,file_name="summarystats",
file_type="csv",dir_path=tempdir())

}

}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
