% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.ph2simon.R
\name{autoplot.ph2simon}
\alias{autoplot.ph2simon}
\alias{autolayer.ph2simon}
\title{Plot Simon's Two-Stage Design}
\usage{
\method{autoplot}{ph2simon}(object, ...)

\method{autolayer}{ph2simon}(
  object,
  type = c("minimax", "optimal", "n1", "maximax"),
  n1 = stop("must provide `n1`"),
  n = stop("must provide `n`"),
  r1 = stop("must provide `r1`"),
  r = stop("must provide `r`"),
  pu = stop("must provide `pu`"),
  pa = stop("must provide `pa`"),
  ...
)
}
\arguments{
\item{object}{\link[clinfun]{ph2simon} object}

\item{...}{potential parameters, currently not in use}

\item{type}{\link[base]{character} scalar, one of
\code{'minimax'}, \code{'optimal'}, \code{'n1'} and \code{'maximax'}}

\item{n1, n}{(optional) \link[base]{integer} scalars, Stage-1 sample size \eqn{n_1}
and total sample size \eqn{n}.  Overridden if \code{object} is given}

\item{r1, r}{(optional) \link[base]{integer} scalars, number of response
in Stage-1 \eqn{r_1} and overall \eqn{r} required \emph{exclusively},
i.e., passing Stage-1 means observing \eqn{>r_1} response.
Overridden if \code{object} is given}

\item{pu, pa}{\link[base]{double} scalars, see function \link[clinfun]{ph2simon}}
}
\value{
Function \link{autoplot.ph2simon} returns a \link[ggplot2]{ggplot} object.

Function \link{autolayer.ph2simon} returns a \link[base]{list} of \link[ggplot2]{ggproto} and labels.
}
\description{
Plot \link[clinfun]{ph2simon} object using \CRANpkg{ggplot2}.
}
\examples{
library(clinfun)
(x = ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
class(x)
autoplot(x, type = 'minimax')
autoplot(x, type = 'optimal')
autoplot(x, type = 'n1')
autoplot(x, type = 'maximax')

# example with r1 = 0
(des = ph2simon(pu = .05, pa = .3, ep1 = .05, ep2 = .2))
autoplot(des, type = 'optimal')
autoplot(des, type = 'minimax')

}
