% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0S4.R, R/simon_pr.R
\docType{class}
\name{simon_pr}
\alias{simon_pr}
\alias{simon_pr-class}
\alias{simon_pr.ph2simon}
\alias{simon_pr.ph2simon4}
\title{Probabilities of one Simon's Two-Stage Design}
\usage{
simon_pr(prob, object, ...)

\method{simon_pr}{ph2simon}(prob, object, ...)

\method{simon_pr}{ph2simon4}(
  prob,
  object,
  r1 = object@r1,
  n1 = object@n1,
  r = object@r,
  n = object@n,
  ...
)
}
\arguments{
\item{prob}{\link[base]{double} scalar or \link[base]{vector},
true response rate(s) \eqn{p}}

\item{object}{a \link[clinfun]{ph2simon} or \linkS4class{ph2simon4} object}

\item{...}{parameters of function \code{\link[=ph2simon4]{ph2simon4()}}, most importantly \code{type}}

\item{r1, n1, r, n}{(optional) \link[base]{integer} scalars, see \linkS4class{ph2simon4}.}
}
\value{
Function \code{\link[=simon_pr]{simon_pr()}} returns \linkS4class{simon_pr} object.
}
\description{
Probabilities of frail
(i.e., early termination) and success (to reject \eqn{H_0})
of \strong{one} Simon's two-stage design, at given true response rate(s).
}
\section{Slots}{

\describe{
\item{\code{frail}}{\link[base]{numeric} scalar or \link[base]{vector},
probabilities of frail (i.e., early termination)
at given true response rate(s) \eqn{p}.}

\item{\code{reject}}{\link[base]{numeric} scalar or \link[base]{vector},
probabilities of success (to reject \eqn{H_0})
at given true response rate(s) \eqn{p}.}

\item{\code{eN}}{\link[base]{numeric} scalar or \link[base]{vector},
expected sample size(s) \eqn{\textrm{E}(n)}
at given true response rate(s) \eqn{p}.}

\item{\code{prob}}{\link[base]{double} scalar or \link[base]{vector}, true response rate(s) \eqn{p}}
}}

\keyword{internal}
