% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.viztest}
\alias{plot.viztest}
\title{Plot Method for viztest Objects}
\usage{
\method{plot}{viztest}(
  x,
  ...,
  ref_lines = "none",
  viz_diff_thresh = 0.02,
  make_plot = TRUE,
  level = c("ce", "max", "min", "median"),
  trans = I
)
}
\arguments{
\item{x}{Object to be plotted, should be of class \code{viztest}}

\item{...}{Other arguments passed down.  Currently not implemented.}

\item{ref_lines}{Reference lines to be plotted - one of "all", "ambiguous", "none".  This could also be a vector of stimulus names to plot - they should be the same as the names of the estimates in \code{x$est}. See details for explanation.}

\item{viz_diff_thresh}{Threshold for identifying visual difficulty, see details.}

\item{make_plot}{Logical indicating whether the plot should be constructed or the data returned.}

\item{level}{Level at which to plot the estimates.  Accepts both numeric entries or one of "ce", "max", "min", "median" - defaults to "ce", the cognitively easiest level.}

\item{trans}{A function to transform the estimates and their confidence intervals like \code{plogis}.}
}
\value{
By default, a ggplot is returned.  If \code{make_plot = FALSE}, the data for the plot are returned, but the plot is not constructed.  If the data are returned, the following variables are in the dataset:
\itemize{
\item \code{vbl} - The name of the parameter.
\item \code{est} - The parameter estimate
\item \code{se} - The standard error of the estimate
\item \code{lwr}, \code{upr} - The inferential confidence bounds being used
\item \code{label} - Factor giving the parameter names
\item \code{stim_start}, \code{stim_end} - y-axis bounds of the reference line
\item \code{bound_start}, \code{bound_end} - x-axis values for reference lines
\item \code{ambiguous} - Logical vector indicating whether the comparison is considered "ambiguous".
}
}
\description{
Plots the output of viztest objects with optional reference lines
}
\details{
The \code{ref_lines} argument identifies what reference lines will be plotted in the figure.  For any particular stimulus, the reference lines run along the upper bound of the stimulus from the stimulus location to the most distant stimulus with overlapping confidence intervals.
When \code{ref_lines = "all"}, all lines are plotted, though in displays with many stimuli, this can make for a messy graph.  When \code{"ref_lines = ambiguous"} is specified, then only the ones that help discriminate in cases where the result might be visually difficult to discern are plotted.
A comparison is determined to be visually difficult if the upper bound of the stimulus in question is within \code{viz_diff_thresh} times the difference between the smallest lower bound and the largest upper bound.  If \code{ref_lines = "non"}, then none of the reference lines are plotted.
Alternatively, you can specify the names of stimuli whose reference lines will be plotted.  These should be the same as the names in the data.  The \code{viztest()} function returns an object \code{est}, which contains the data that are used as input to this function.  The variable \code{vbl} in
The \code{est} data frame contains the stimulus names.
}
\examples{
data(mtcars)
mod2 <- lm(mpg ~ as.factor(cyl) + vs + am + as.factor(gear), data = mtcars)
v <- viztest(mod2)
plot(v, ref_lines="ambiguous") + ggplot2::theme_classic()

}
