% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{resource_discrete}
\alias{resource_discrete}
\title{Create a discrete resource}
\usage{
resource_discrete(n)
}
\arguments{
\item{n}{Integer. The total capacity of the resource (must be >= 1).}
}
\value{
An environment with methods for resource management.
}
\description{
Creates a discrete resource management system for discrete event simulations.
This system manages a fixed number of identical resource units that can be
blocked (used) by patients and maintains a priority queue for waiting patients.
}
\details{
The returned environment has the following methods:
\itemize{
\item \code{size()}: Returns the total capacity
\item \code{queue_size()}: Returns the number of patients in queue
\item \code{n_free()}: Returns the number of free resource units
\item \code{patients_using()}: Vector of patient IDs currently using the resource
\item \code{patients_using_times()}: Vector of start times for patients using the resource
\item \code{queue_start_times()}: Vector of queue start times parallel to queue order
\item \code{queue_priorities()}: Vector of priorities parallel to queue order
\item \code{queue_info(n)}: Data.frame with patient_id, priority, start_time for queue
\item \code{is_patient_in_queue(patient_id)}: Check if patient is in queue
\item \code{is_patient_using(patient_id)}: Check if patient is using resource
\item \code{attempt_block(patient_id, priority, start_time)}: Attempt to block a resource unit
\item \code{attempt_free(patient_id, remove_all)}: Free a resource unit
\item \code{attempt_free_if_using(patient_id, remove_all)}: Free only if patient is using
\item \code{next_patient_in_line(n)}: Get next n patients in queue
\item \code{modify_priority(patient_id, new_priority)}: Modify patient priority in queue
\item \code{add_resource(n)}: Add n resource units to total capacity
\item \code{remove_resource(n, current_time)}: Remove n resource units from total capacity
}
}
\examples{
# Create a resource with 3 units
beds <- resource_discrete(3)

# Check initial state
beds$size()      # 3
beds$n_free()    # 3
beds$queue_size() # 0

# Block resources
i <- 101; curtime <- 0.0
beds$attempt_block()  # Uses i and curtime from environment

# Or explicitly
beds$attempt_block(patient_id = 102, priority = 1, start_time = 1.0)

# Check patient status
beds$is_patient_using(101)     # TRUE
beds$is_patient_in_queue(102)  # FALSE

}
