% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynaplot.R
\name{dynaplot}
\alias{dynaplot}
\alias{dynaplot.tidal}
\alias{dynaplot.tidalmean}
\title{Plot model response to salinity or flow as a lineplot for all months}
\usage{
dynaplot(dat_in, ...)

\method{dynaplot}{tidal}(dat_in, month = c(1:12), tau = NULL,
  years = NULL, col_vec = NULL, alpha = 1, size = 1, logspace = TRUE,
  floscl = TRUE, allflo = FALSE, ncol = NULL, grids = TRUE,
  scales = NULL, pretty = TRUE, use_bw = TRUE, fac_nms = NULL, ...)

\method{dynaplot}{tidalmean}(dat_in, month = c(1:12), years = NULL,
  col_vec = NULL, alpha = 1, size = 1, logspace = TRUE, floscl = TRUE,
  allflo = FALSE, ncol = NULL, grids = TRUE, scales = NULL,
  pretty = TRUE, use_bw = TRUE, fac_nms = NULL, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{month}{numeric input from 1 to 12 indicating the monthly predictions to plot}

\item{tau}{numeric vector of quantile to plot.  The function will plot the 'middle' quantile if none is specified, e.g., if 0.2, 0.3, and 0.4 are present in the fitted model object then 0.3 will be plotted.}

\item{years}{numeric vector of years to plot, one to many, defaults to all}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}} and \code{\link[ggplot2]{scale_colour_gradientn}} for line shading.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{alpha}{numeric value from zero to one indicating line transparency}

\item{size}{numeric value for line size}

\item{logspace}{logical indicating if plots are in log space}

\item{floscl}{logical indicating if salinity/flow on x-axis is standardized (default) or in original scale}

\item{allflo}{logical indicating if the salinity or flow values for plotting are limited to the fifth and ninety-fifth percentile of observed values for the month of interest}

\item{ncol}{numeric argument passed to \code{\link[ggplot2]{facet_wrap}} indicating number of facet columns}

\item{grids}{logical indicating if grid lines are present}

\item{scales}{chr string passed to ggplot to change x/y axis scaling on facets, acceptable values are \code{'free'}, \code{'free_x'}, or \code{'free_y'}}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used.  The aesthetic arguments will not apply if \code{pretty = TRUE}.}

\item{use_bw}{logical indicating if the \code{\link[ggplot2]{theme_bw}} theme is used}

\item{fac_nms}{optional chr string for facet labels, which must be equal in length to \code{month}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot the relationship between the modelled response and salinity/flow across the time series using line plots for each month.  Each line corresponds to a unique year.  This can be used to evaluate temporal variation between the two.
}
\details{
These plots can be used to examine how the relationship between the response variable and flow varies throughout the time series.  It is essentially identical to the plot produced by \code{\link{gridplot}}, except lines plots are returned that show the relationship of the response variable with salinity/flow using different lines for each year. The interpolation grid that is stored as an attribute in a fitted tidal object is used to create the plot.  Each plot is limited to the same month throughout the time series to limit seasonal variation.  Plots are also constrained to the fifth and ninety-fifth percentile of observed salinity/flow values during the month of interest to limit the predictions within the data domain. This behavior can be suppressed by changing the \code{allflo} argument. 

Note that the year variable used for color mapping is treated as a continuous variable although it is an integer by definition.
}
\examples{

# load a fitted tidal object
data(tidfit)

# plot using defaults, 
# defaults to the fiftieth quantile for all years
dynaplot(tidfit)
\dontrun{
# change the defaults
dynaplot(tidfit, tau = 0.9, month = 2, years = seq(1980, 1990), 
 col_vec = rainbow(7), alpha = 0.5, size = 3) 
 
# plot a tidalmean object
data(tidfitmean)

dynaplot(tidfitmean)
}
}
\seealso{
\code{\link{fitplot}}, \code{\link{gridplot}}, \code{\link{prdnrmplot}}
}
