% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbalanced_transport.R
\name{kr_dist}
\alias{kr_dist}
\title{Compute the p-Kantorovich-Rubinstein distance between two measures of possibly unequal total mass.}
\usage{
kr_dist(A, B, p = 2, C)
}
\arguments{
\item{A}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{B}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{p}{A positive real number specifying the order of the Kantorovich-Rubinstein distance.}

\item{C}{A positive real number specifying the cost parameter of the Kantorovich-Rubinstein distance.}
}
\value{
A list containing an entry "distance" (specifying the KR distance between the two measures) and an 
entry "plan" containing an optimal plan for the unbalanced optimal transport problem.
}
\description{
This function constructs the corresponding problem and solves it suing the \link[transport]{transport}-function.
}
\examples{
M<-1000
W1<-runif(M)
W2<-runif(M)
pos1<-matrix(runif(M*2),M,2)
pos2<-matrix(runif(M*2),M,2)
wpp1<-transport::wpp(pos1,W1)
wpp2<-transport::wpp(pos2,W2)
system.time(res<-WSGeometry:::kr_dist(wpp1,wpp2,2,2))
}
\references{
Kantorovich-Rubinstein distance and barycenter for finitely supported measures:  Foundations and Algorithms; Florian Heinemann, Marcel Klatt, Axel Munk; https://arxiv.org/pdf/2112.03581.pdf.
}
