% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShadowHist.R
\name{ShadowHist}
\alias{ShadowHist}
\title{Plot a Shadow Histogram Plot}
\usage{
ShadowHist(frm, xvar, condvar, title, ..., ncol = 1, palette = "Dark2",
  bins = 30, binwidth = NULL)
}
\arguments{
\item{frm}{data frame to get values from.}

\item{xvar}{name of the primary continuous variable}

\item{condvar}{name of conditioning variable (categorical variable, controls faceting).}

\item{title}{title to place on plot.}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{ncol}{numeric: number of columns in facet_wrap.}

\item{palette}{character: name of brewer color palette (can be NULL)}

\item{bins}{number of bins. Defaults to thirty.}

\item{binwidth}{width of the bins. Overrides bins.}
}
\value{
a ggplot2 histogram plot
}
\description{
Plot a histogram of a continuous variable \code{xvar},
faceted on a categorical conditioning variable, \code{condvar}. Each faceted plot
also shows a "shadow plot" of the unconditioned histogram for comparison.
}
\details{
Currently supports only the \code{bins} and \code{binwidth} arguments (see \code{\link[ggplot2]{geom_histogram}}),
but not the \code{center}, \code{boundary}, or \code{breaks} arguments.

By default, the facet plots are arranged in a single column. This can be changed
with the optional \code{ncol} argument.

If \code{palette} is NULL, plot colors will be chosen from the default ggplot2 palette. Setting \code{palette} to NULL
allows the user to choose a non-Brewer palette, for example with \code{\link[ggplot2]{scale_fill_manual}}.
}
\examples{

ShadowHist(iris, "Petal.Length", "Species",
           title = "Petal Length distribution by Species")

}
