% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_timeOpt.R
\name{win_timeOpt}
\alias{win_timeOpt}
\title{Windowed timeOpt sedimentation rate estimation}
\usage{
win_timeOpt(
  data = NULL,
  window_size = 10,
  sedmin = 0.5,
  sedmax = 2,
  numsed = 100,
  limit = FALSE,
  fit = 2,
  fitModPwr = TRUE,
  flow = NULL,
  fhigh = NULL,
  roll = 10^6,
  targetE = c(405.7, 130.7, 123.8, 98.9, 94.9),
  targetP = c(20.9, 19.9, 17.1, 17.2),
  detrend = TRUE,
  normalize = TRUE,
  linLog = 1,
  run_multicore = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Input data set  should consist of a matrix with 2 columns with the
first column being depth and the second column being a proxy \code{Default=NULL}}

\item{window_size}{size of the moving window in metres \code{Default=15}}

\item{sedmin}{Minimum sedimentation rate for investigation (cm/ka). \code{Default=0.1}}

\item{sedmax}{Maximum sedimentation rate for investigation (cm/ka). \code{Default=1}}

\item{numsed}{Number of sedimentation rates to investigate
in optimization grid. \code{Default=100}}

\item{limit}{Limit evaluated sedimentation rates to region in which full
target signal can be recovered? .\code{Default=FALSE}}

\item{fit}{Test for (1) precession amplitude modulation or (2) short
eccentricity amplitude modulation? \code{Default=2}}

\item{fitModPwr}{Include the modulation periods
in the spectral fit? \code{Default=TRUE}}

\item{flow}{Low frequency cut-off for
Taner bandpass (half power point in cycles/ka) \code{Default=TRUE}}

\item{fhigh}{High frequency cut-off for
Taner bandpass (half power point; in cycles/ka) \code{Default=NULL}}

\item{roll}{Taner filter roll-off rate, in dB/octave. \code{Default=c(10^6)}}

\item{targetE}{A vector of eccentricity periods to evaluate (in ka).
These must be in order of decreasing period, with a first value of 405 ka.
\code{Default= "c(405.7, 130.7, 123.8, 98.9, 94.9)"}}

\item{targetP}{A vector of precession periods to evaluate (in ka).
These must be in order of decreasing period. \code{Default=c(20.9, 19.9, 17.1, 17.2)}}

\item{detrend}{Remove linear trend from data series? \code{Default=TRUE}}

\item{normalize}{normalize the r2 curves of individual timeOpt runs \code{Default=TRUE}}

\item{linLog}{Use linear or logarithmic scaling for sedimentation
rate grid spacing? (0=linear, 1=log; default value is 1) \code{Default=1}}

\item{run_multicore}{Run function using multiple cores \code{Default=FALSE}}

\item{verbose}{print text \code{Default=FALSE}}
}
\value{
Returns a list which contains 10 elements
element 1: r_2_envelope matrix
element 2: r_2_power matrix
element 3: r_2_opt matrix
element 4: r_2_envelope_avg
element 5: r_2_opt_avg
element 6: depth
element 7: y_axis
element 8: linLog value
}
\description{
The \code{\link{win_timeOpt}} function for conducts a widowed
timeOpt sedimentation rate estimation
This function is based on the \code{\link[astrochron:eTimeOpt]{eTimeOpt}} but allows for
multithreaded analysis speeding up the
process of conducting a Windowed timeOpt sedimentation rate estimation
}
\examples{
\donttest{
#Conduct a windowed timeOpt on the magnetic susceptibility record
#of the Sullivan core of Pas et al., (2018).
mag_win_timeOpt <-win_timeOpt(
data = mag,
window_size = 15,
sedmin = 0.1,
sedmax = 1,
numsed = 100,
limit = FALSE,
fit = 2,
fitModPwr = TRUE,
flow = NULL,
fhigh = NULL,
roll = 10 ^ 6,
targetE = c(405.7, 130.7, 123.8, 98.9, 94.9),
targetP = c(20.9, 19.9, 17.1, 17.2),
detrend = TRUE,
normalize =TRUE,
linLog = 1,
run_multicore =FALSE,
verbose=FALSE)
}

}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
Based on the \code{\link[astrochron:eTimeOpt]{eTimeOpt}}
function of the 'astrochron' R package.
}
