\name{wiki_pagecats}
\alias{wiki_pagecats}
\title{
Retrieves categories associated with a page
}
\description{
Retrieves categories associated with a page (or list of pages) on a MediaWiki instance
}
\usage{
wiki_pagecats(con, pages, properties = c("sortkey", "timestamp", "hidden"),
              limit = 50, show_hidden = FALSE)
}
\arguments{
  \item{con}{
A connector object, generated by \code{\link{wiki_con}}, that corresponds to the project you're trying to query.
}
  \item{pages}{
A vector of page titles, with or without spaces, that you want to retrieve categories for.
}
  \item{properties}{
The properties you want to retrieve about the categories. Options are "sortkey" (the key that sorts the way the page is stored in each category), "timestamp" (when the category was added to that page) and "hidden" (tags those categories in the returned list that are 'hidden' from readers)}
  \item{limit}{
The maximum number of categories you want to retrieve for each page
}
  \item{show_hidden}{
Whether or not to include 'hidden' categories in the categories that are retrieved - these are usually associated with the maintenance of Wikipedia and its internal processes.}
}
\seealso{
\code{\link{wiki_catpages}} for pages in a specified category
}
\examples{
#Create a connector
connector <- wiki_con(language = "en", project = "wikipedia")

#Retrieve the categories associated with the article "Kidnapping in the United Kingdom"
wiki_pagecats(con = connector, pages = "Kidnapping in the United Kingdom", properties = "hidden")

}