% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tokenizer.R
\name{readTokens}
\alias{readTokens}
\alias{readlines}
\title{Read the remaining tokens from a \code{Tokenizer} up to the end of the underlying file.}
\usage{
# readTokens(mytok)
# readTokens(Tokenizer$new("myfile.txt"),c("0x20L"))

# readlines("myfile.txt")
}
\arguments{
\item{tok}{The tokenizer from which to read.}

\item{delims}{The delimiters to use for the remaining tokens.}

\item{filename}{The file to read.}
}
\value{
A vector of strings representing the read tokens.

A vector of strings representing the lines of the file.
}
\description{
A comfortable way to read all remaining tokens from a file open through a tokenizer..

A comfortable way to read all lines from a file. Syntactic sugar for \code{readTokens(Tokenizer$new(filename),delims=c(10L,13L))}.
}
\examples{
\dontrun{
tok<-Tokenizer$new("myfile.txt")           # create a tokenizer
tok$nextToken()                            # read some tokens
readTokens(tok,as.integer(charToRaw("+"))) # read the rest of the file, now delimited by "+"
readTokens(Tokenizer$new("myfile.txt"))    # read all tokens
readTokens("myfile.txt")                   # same as above, syntactic sugar
}
\dontrun{
readlines("myfile.txt")
}
}

