% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xSparseMatrix.r
\name{xSparseMatrix}
\alias{xSparseMatrix}
\title{Function to create a sparse matrix for an input file with three columns}
\usage{
xSparseMatrix(input.file, rows = NULL, columns = NULL, verbose = T)
}
\arguments{
\item{input.file}{an input file containing three columns: 1st column
for rows, 2nd for columns, and 3rd for numeric values. Alternatively,
the input.file can be a matrix or data frame, assuming that input file
has been read. Note: the file should use the tab delimiter as the field
separator between columns}

\item{rows}{a vector specifying row names. By default, it is NULL}

\item{columns}{a vector specifying column names. By default, it is
NULL}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
an object of the dgCMatrix class (a sparse matrix)
}
\description{
\code{xSparseMatrix} is supposed to create a sparse matrix for an input
file with three columns.
}
\note{
If rows (or columns) are not NULL, the rows (or columns) of resulting
sparse matrix will be union of those from input.file and those from
rows (or columns).
None
}
\examples{
# create a sparse matrix of 4 X 2
input.file <- rbind(c('R1','C1',1), c('R2','C1',1), c('R2','C2',1),
c('R3','C2',1), c('R4','C1',1))
res <- xSparseMatrix(input.file)
res
# get a full matrix
as.matrix(res)

res <- xSparseMatrix(input.file, columns=c('C1','C2','C3'))
res
}
\seealso{
\code{\link{xSparseMatrix}}
}

