% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSNP2nGenes.r
\name{xSNP2nGenes}
\alias{xSNP2nGenes}
\title{Function to define nearby genes given a list of SNPs}
\usage{
xSNP2nGenes(data, distance.max = 2e+05, decay.kernel = c("rapid",
"slow",
"linear", "constant"), decay.exponent = 2, GR.SNP = c("dbSNP_GWAS",
"dbSNP_Common"), GR.Gene = c("UCSC_knownGene", "UCSC_knownCanonical"),
verbose = T, RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{a input vector containing SNPs. SNPs should be provided as
dbSNP ID (ie starting with rs). Alternatively, they can be in the
format of 'chrN:xxx', where N is either 1-22 or X, xxx is genomic
positional number; for example, 'chr16:28525386'}

\item{distance.max}{the maximum distance between genes and SNPs. Only
those genes no far way from this distance will be considered as seed
genes. This parameter will influence the distance-component weights
calculated for nearby SNPs per gene}

\item{decay.kernel}{a character specifying a decay kernel function. It
can be one of 'slow' for slow decay, 'linear' for linear decay, and
'rapid' for rapid decay. If no distance weight is used, please select
'constant'}

\item{decay.exponent}{a numeric specifying a decay exponent. By
default, it sets to 2}

\item{GR.SNP}{the genomic regions of SNPs. By default, it is
'dbSNP_GWAS', that is, SNPs from dbSNP (version 146) restricted to GWAS
SNPs and their LD SNPs (hg19). It can be 'dbSNP_Common', that is,
Common SNPs from dbSNP (version 146) plus GWAS SNPs and their LD SNPs
(hg19). Alternatively, the user can specify the customised input. To do
so, first save your RData file (containing an GR object) into your
local computer, and make sure the GR object content names refer to
dbSNP IDs. Then, tell "GR.SNP" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{GR.Gene}{the genomic regions of genes. By default, it is
'UCSC_knownGene', that is, UCSC known genes (together with genomic
locations) based on human genome assembly hg19. It can be
'UCSC_knownCanonical', that is, UCSC known canonical genes (together
with genomic locations) based on human genome assembly hg19.
Alternatively, the user can specify the customised input. To do so,
first save your RData file (containing an GR object) into your local
computer, and make sure the GR object content names refer to Gene
Symbols. Then, tell "GR.Gene" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a data frame with following columns:
\itemize{
\item{\code{Gene}: nearby genes}
\item{\code{SNP}: SNPs}
\item{\code{Dist}: the genomic distance between the gene and the SNP}
\item{\code{Weight}: the distance weight based on the genomic distance}
}
}
\description{
\code{xSNP2nGenes} is supposed to define nearby genes given a list of
SNPs within certain distance window. The distance weight is calcualted
as a decaying function of the gene-to-SNP distance.
}
\note{
For details on the decay kernels, please refer to
\code{\link{xVisKernels}}
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"

# a) provide the seed SNPs with the significance info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
data <- names(gr)

# b) define nearby genes
df_nGenes <- xSNP2nGenes(data=data, distance.max=200000,
decay.kernel="slow", decay.exponent=2, RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}, \code{\link{xVisKernels}}
}

