% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xRepurpose.r
\name{xRepurpose}
\alias{xRepurpose}
\title{Function to obtain repurposing matrix}
\usage{
xRepurpose(data, phase.min = 3, target.max = 5, plot = TRUE,
verbose = T, DTT = c("ChEMBL_v24", "ChEMBL_v23"), restricted = NULL,
excluded = NULL, RData.location =
"http://galahad.well.ox.ac.uk/bigdata",
...)
}
\arguments{
\item{data}{an input vector containing gene symbols}

\item{phase.min}{the minumum phase of drugs allowed. By default it is 3
defining target genes of drugs reaching development phase 3 and above}

\item{target.max}{the maximum number of targets per drug allowed. By
default it is 5. It is used to define non-promoscuous drug target
genes}

\item{plot}{logical to indicate whether heatmap plot is drawn}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{DTT}{the drug therapeutic targets. It can be "ChEMBL_v24" for the
version 24 (by default), and the version 23. Note: you can also load
your customised object directly with columns
('target_number','efo_term','phase','pref_name_drug','Symbol')}

\item{restricted}{the disease areas restricted to. By default it is
NULL}

\item{excluded}{the disease areas that are excluded. By default it is
NULL}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}

\item{...}{additional graphic parameters for xHeatmap}
}
\value{
an object of class "DR", a list with following components:
\itemize{
\item{\code{df}: a data frame of n x 5, where the 5 columns are
"Target", "Disease", "Phase", "Drug", "Drug_index"}
\item{\code{index}: a data frame of n x 2, where the 2 columns are
"Drug_index", "Drug"}
\item{\code{gp}: NULL if the plot is not drawn; otherwise, a 'ggplot'
object}
}
}
\description{
\code{xRepurpose} is supposed to obtain repurposing matrix given a
query list of genes. It returns an object of the class 'DR'.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

# a) provide the input Genes of interest (eg 1000 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg',
RData.location=RData.location)
set.seed(825)
data <- as.character(sample(org.Hs.eg$gene_info$Symbol, 1000))

# b) obtain repurposing matrix
DR <- xRepurpose(data, RData.location=RData.location, reorder="none",
colormap="ggplot2.top", zlim=c(1,4), na.color='transparent',
label.size=1.5, label.color="white")
DR$gp
write.table(DR$df, file="xRepurpose.txt", sep="\\t", row.names=F,
quote=F)
write.table(DR$index, file="xRepurpose_index.txt", sep="\\t",
row.names=F, quote=F)
}
}
\seealso{
\code{\link{xRDataLoader}}, \code{\link{xHeatmap}}
}
