/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.DataFormatOnlyCellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.HCellStyle;
import com.miraisolutions.xlconnect.SSCellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.XCellStyle;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.DateTimeFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;

public final class Workbook
extends Common {
    public static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private final org.apache.poi.ss.usermodel.Workbook workbook;
    private File excelFile;
    private StyleAction styleAction = StyleAction.XLCONNECT;
    private String styleNamePrefix = null;
    private Object[] missingValue = new Object[]{null};
    private final Map<String, Map<String, CellStyle>> stylesMap = new HashMap<String, Map<String, CellStyle>>(10);
    private final Map<DataType, String> dataFormatMap = new EnumMap<DataType, String>(DataType.class);
    private ErrorBehavior onErrorCell = ErrorBehavior.WARN;

    private Workbook(InputStream inputStream) throws IOException, InvalidFormatException {
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
        this.excelFile = null;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private Workbook(File excelFile) throws FileNotFoundException, IOException, InvalidFormatException {
        this(new FileInputStream(excelFile));
        this.excelFile = excelFile;
    }

    private Workbook(File file, SpreadsheetVersion spreadsheetVersion) {
        switch (spreadsheetVersion) {
            case EXCEL97: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case EXCEL2007: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException("Spreadsheet version not supported!");
            }
        }
        this.excelFile = file;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private void initDefaultStyles() {
        CellStyle cellStyle;
        CellStyle cellStyle2;
        HashMap<String, CellStyle> hashMap = new HashMap<String, CellStyle>(5);
        CellStyle cellStyle3 = this.getCellStyle("XLConnect.Header");
        if (cellStyle3 == null) {
            cellStyle3 = this.createCellStyle("XLConnect.Header");
            cellStyle3.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle3.setFillPattern((short)1);
            cellStyle3.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle3.setWrapText(true);
        }
        if ((cellStyle2 = this.getCellStyle("XLConnect.General")) == null) {
            cellStyle2 = this.createCellStyle("XLConnect.General");
            cellStyle2.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle2.setWrapText(true);
        }
        if ((cellStyle = this.getCellStyle("XLConnect.Date")) == null) {
            cellStyle = this.createCellStyle("XLConnect.Date");
            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
            cellStyle.setWrapText(true);
        }
        hashMap.put("Header", cellStyle3);
        hashMap.put("String", cellStyle2);
        hashMap.put("Numeric", cellStyle2);
        hashMap.put("Boolean", cellStyle2);
        hashMap.put("DateTime", cellStyle);
        this.stylesMap.put("XLCONNECT_STYLE", hashMap);
    }

    private void initDefaultDataFormats() {
        this.dataFormatMap.put(DataType.Boolean, "General");
        this.dataFormatMap.put(DataType.DateTime, "mm/dd/yyyy hh:mm:ss");
        this.dataFormatMap.put(DataType.Numeric, "General");
        this.dataFormatMap.put(DataType.String, "General");
    }

    public final void setDataFormat(DataType dataType, String string) {
        this.dataFormatMap.put(dataType, string);
    }

    public final void setStyleAction(StyleAction styleAction) {
        this.styleAction = styleAction;
    }

    public final void setStyleNamePrefix(String styleNamePrefix) {
        this.styleNamePrefix = styleNamePrefix;
    }

    public final String[] getSheets() {
        int count = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[count];
        for (int i = 0; i < count; ++i) {
            sheetNames[i] = this.workbook.getSheetName(i);
        }
        return sheetNames;
    }

    public final int getSheetPos(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    public final void setSheetPos(String sheetName, int pos) {
        this.workbook.setSheetOrder(sheetName, pos);
    }

    public final String[] getDefinedNames(boolean bl) {
        int n = this.workbook.getNumberOfNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Name name = this.workbook.getNameAt(i);
            if (bl && !Workbook.isValidReference(name.getRefersToFormula())) continue;
            arrayList.add(name.getNameName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final boolean existsSheet(String string) {
        return this.workbook.getSheet(string) != null;
    }

    public final boolean existsName(String string) {
        return this.workbook.getName(string) != null;
    }

    public final void createSheet(String string) {
        if (string.length() > 31) {
            throw new IllegalArgumentException("Sheet names are not allowed to contain more than 31 characters!");
        }
        if (this.workbook.getSheetIndex(string) < 0) {
            this.workbook.createSheet(string);
        }
    }

    public final void removeSheet(int sheetIndex) {
        if (sheetIndex > -1 && sheetIndex < this.workbook.getNumberOfSheets()) {
            this.setAlternativeActiveSheet(sheetIndex);
            this.workbook.removeSheetAt(sheetIndex);
        }
    }

    public final void removeSheet(String name) {
        this.removeSheet(this.workbook.getSheetIndex(name));
    }

    public final void renameSheet(int sheetIndex, String newName) {
        this.renameSheet(this.workbook.getSheetName(sheetIndex), newName);
    }

    public final void renameSheet(String name, String newName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex(name), newName);
    }

    public final void cloneSheet(int index, String newName) {
        this.cloneSheet(this.workbook.getSheetName(index), newName);
    }

    public final void cloneSheet(String name, String newName) {
        Sheet sheet = this.workbook.cloneSheet(this.workbook.getSheetIndex(name));
        this.workbook.setSheetName(this.workbook.getSheetIndex(sheet), newName);
    }

    public final void createName(String string, String string2, boolean bl) {
        if (this.existsName(string)) {
            if (bl) {
                this.removeName(string);
            } else {
                throw new IllegalArgumentException("Specified name '" + string + "' already exists!");
            }
        }
        Name name = this.workbook.createName();
        try {
            name.setNameName(string);
            name.setRefersToFormula(string2);
            return;
        }
        catch (Exception exception) {
            string2 = "XLConnectDummyName";
            name.setNameName(string2);
            this.removeName(string2);
            throw new IllegalArgumentException(exception);
        }
    }

    public final void removeName(String string) {
        if (this.workbook.getName(string) != null) {
            this.workbook.removeName(string);
        }
    }

    public final String getReferenceFormula(String name) {
        return this.getName(name).getRefersToFormula();
    }

    public final int[] getReferenceCoordinates(String string) {
        Workbook workbook = workbook.getName(string);
        workbook = new AreaReference(workbook.getRefersToFormula());
        string = workbook.getFirstCell();
        workbook = workbook.getLastCell();
        int n = string.getRow();
        int n2 = workbook.getRow();
        short s = string.getCol();
        short s2 = workbook.getCol();
        return new int[]{n, s, n2, s2};
    }

    private void writeData(DataFrame dataFrame, Sheet sheet, int n, int n2, boolean n3) {
        int n4;
        int n5;
        Object object = sheet;
        DataFrame dataFrame2 = dataFrame;
        Map<String, CellStyle> map = this;
        Serializable serializable = new HashMap<String, CellStyle>(dataFrame2.columns());
        switch (((Workbook)((Object)map)).styleAction) {
            case XLCONNECT: {
                map = ((Workbook)((Object)map)).stylesMap.get("XLCONNECT_STYLE");
                if (dataFrame2.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                        serializable.put("Header" + n5, map.get("Header"));
                    }
                }
                block20: for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                    switch (dataFrame2.getColumnType(n5)) {
                        case Boolean: {
                            serializable.put("Column" + n5, map.get("Boolean"));
                            continue block20;
                        }
                        case DateTime: {
                            serializable.put("Column" + n5, map.get("DateTime"));
                            continue block20;
                        }
                        case Numeric: {
                            serializable.put("Column" + n5, map.get("Numeric"));
                            continue block20;
                        }
                        case String: {
                            serializable.put("Column" + n5, map.get("String"));
                            continue block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type detected!");
                        }
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            case PREDEFINED: {
                if (dataFrame2.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                        n4 = n2 + n5;
                        serializable.put("Header" + n5, super.getCellStyle(Workbook.getCell(object, n, n4, true)));
                    }
                }
                n5 = n + (dataFrame2.hasColumnHeader() ? 1 : 0);
                for (int i = 0; i < dataFrame2.columns(); ++i) {
                    n4 = n2 + i;
                    int n6 = n5;
                    Cell cell = Workbook.getCell(object, n6, n4, true);
                    serializable.put("Column" + i, super.getCellStyle(cell));
                }
                break;
            }
            case STYLE_NAME_PREFIX: {
                String string;
                int n7;
                if (dataFrame2.hasColumnHeader()) {
                    for (n7 = 0; n7 < dataFrame2.columns(); ++n7) {
                        string = ((Workbook)((Object)map)).styleNamePrefix + "." + "Header";
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnName(n7));
                        if (object == null) {
                            object = ((Workbook)((Object)map)).getCellStyle(string + "." + (n7 + 1));
                        }
                        if (object == null) {
                            object = ((Workbook)((Object)map)).getCellStyle(string);
                        }
                        if (object == null) {
                            object = new SSCellStyle(((Workbook)((Object)map)).workbook, ((Workbook)((Object)map)).workbook.getCellStyleAt((short)0));
                        }
                        serializable.put("Header" + n7, object);
                    }
                }
                for (n7 = 0; n7 < dataFrame2.columns(); ++n7) {
                    string = ((Workbook)((Object)map)).styleNamePrefix + "." + "Column";
                    object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnName(n7));
                    if (object == null) {
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + (n7 + 1));
                    }
                    if (object == null) {
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnType(n7).toString());
                    }
                    if (object == null) {
                        object = new SSCellStyle(((Workbook)((Object)map)).workbook, ((Workbook)((Object)map)).workbook.getCellStyleAt((short)0));
                    }
                    serializable.put("Column" + n7, object);
                }
                break;
            }
            case DATA_FORMAT_ONLY: {
                int n8;
                DataFormatOnlyCellStyle dataFormatOnlyCellStyle = DataFormatOnlyCellStyle.get();
                if (dataFrame2.hasColumnHeader()) {
                    for (n8 = 0; n8 < dataFrame2.columns(); ++n8) {
                        serializable.put("Header" + n8, dataFormatOnlyCellStyle);
                    }
                }
                for (n8 = 0; n8 < dataFrame2.columns(); ++n8) {
                    serializable.put("Column" + n8, dataFormatOnlyCellStyle);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Style action not supported!");
            }
        }
        map = serializable;
        int n9 = n;
        int n10 = n2;
        if (n3 != 0 && dataFrame.hasColumnHeader()) {
            for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                n4 = n2 + n3;
                Cell cell = Workbook.getCell(sheet, n, n4, true);
                cell.setCellValue(dataFrame.getColumnName(n3));
                cell.setCellType(1);
                this.setCellStyle(cell, map.get("Header" + n3));
            }
            ++n9;
        }
        for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
            CellStyle cellStyle = map.get("Column" + n3);
            switch (dataFrame.getColumnType(n3)) {
                case Numeric: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (n2 = 0; n2 < dataFrame.rows(); ++n2) {
                        n4 = n10;
                        n11 = n9 + n2;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        serializable = (Double)arrayList.get(n2);
                        if (serializable == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(((Double)serializable).doubleValue());
                        cell.setCellType(0);
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case String: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (n5 = 0; n5 < dataFrame.rows(); ++n5) {
                        n4 = n10;
                        n11 = n9 + n5;
                        serializable = Workbook.getCell(sheet, n11, n4, true);
                        if ((String)arrayList.get(n5) == null) {
                            this.setMissing((Cell)serializable);
                            continue;
                        }
                        serializable.setCellValue((String)arrayList.get(n5));
                        serializable.setCellType(1);
                        this.setCellStyle((Cell)serializable, cellStyle);
                    }
                    break;
                }
                case Boolean: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (int i = 0; i < dataFrame.rows(); ++i) {
                        n4 = n10;
                        n11 = n9 + i;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        if ((Boolean)arrayList.get(i) == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(((Boolean)arrayList.get(i)).booleanValue());
                        cell.setCellType(4);
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case DateTime: {
                    int n11;
                    serializable = dataFrame.getColumn(n3);
                    for (n = 0; n < dataFrame.rows(); ++n) {
                        n4 = n10;
                        n11 = n9 + n;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        Date date = (Date)((ArrayList)serializable).get(n);
                        if (date == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(date);
                        cell.setCellType(0);
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
            ++n10;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            ((HSSFSheet)sheet).setForceFormulaRecalculation(true);
        }
    }

    private DataFrame readData(Sheet sheet, int n, int n2, int n3, int n4, boolean bl, DataType[] dataTypeArray, boolean bl2, String string, boolean bl3, int[] nArray) {
        DataFrame dataFrame = new DataFrame();
        FormulaEvaluator formulaEvaluator = null;
        if (!bl3) {
            formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            formulaEvaluator.clearAllCachedResultValues();
        }
        if (nArray == null) {
            nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
        }
        int[] nArray2 = nArray;
        n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            String[] stringArray;
            int n5;
            Object object;
            Object object2;
            int n6 = nArray2[i];
            int n7 = n2 + n6;
            String string22 = null;
            if (bl && (object2 = Workbook.getCell(sheet, n, n7, false)) != null) {
                if (!bl3) {
                    object = formulaEvaluator.evaluate((Cell)object2);
                    if (object != null) {
                        string22 = object.getStringValue();
                    }
                } else {
                    string22 = object2.getStringCellValue();
                }
            }
            if (string22 == null) {
                string22 = "Col" + (n6 + 1);
            }
            object2 = new ColumnBuilder(n3, bl2, formulaEvaluator, this.onErrorCell, this.missingValue);
            ((ColumnBuilder)object2).setDateTimeFormat(string);
            int n8 = n5 = bl ? 1 : 0;
            while (n5 < n3) {
                int n9 = n + n5;
                stringArray = Workbook.getCell(sheet, n9, n7, false);
                ((ColumnBuilder)object2).addCell((Cell)stringArray);
                ++n5;
            }
            object = dataTypeArray != null && dataTypeArray.length > 0 ? dataTypeArray[n6 % dataTypeArray.length] : ((ColumnBuilder)object2).determineColumnType();
            stringArray = ((ColumnBuilder)object2).build((DataType)((Object)object));
            dataFrame.addColumn(string22, (DataType)((Object)object), (ArrayList)stringArray);
            for (String string22 : ((Common)object2).retrieveWarnings()) {
                this.addWarning(string22);
            }
        }
        return dataFrame;
    }

    public final void onErrorCell(ErrorBehavior eb) {
        this.onErrorCell = eb;
    }

    public final void writeNamedRegion(DataFrame dataFrame, String string, boolean bl) {
        string = this.getName(string);
        this.checkName((Name)string);
        Sheet sheet = this.workbook.getSheet(string.getSheetName());
        CellReference cellReference = new AreaReference(string.getRefersToFormula()).getFirstCell();
        int n = Math.max(cellReference.getRow() + dataFrame.rows() - 1, cellReference.getRow());
        if (bl) {
            ++n;
        }
        int n2 = Math.max(cellReference.getCol() + dataFrame.columns() - 1, cellReference.getCol());
        CellReference cellReference2 = new CellReference(sheet.getSheetName(), n, n2, true, true);
        cellReference2 = new AreaReference(cellReference, cellReference2);
        string.setRefersToFormula(cellReference2.formatAsString());
        this.writeData(dataFrame, sheet, cellReference.getRow(), cellReference.getCol(), bl);
    }

    public final DataFrame readNamedRegion(String string, boolean bl, DataType[] dataTypeArray, boolean bl2, String string2, boolean bl3, int[] nArray) {
        string = this.getName(string);
        this.checkName((Name)string);
        Sheet sheet = this.workbook.getSheet(string.getSheetName());
        string = new AreaReference(string.getRefersToFormula());
        CellReference cellReference = string.getFirstCell();
        string = string.getLastCell();
        int n = string.getRow() - cellReference.getRow() + 1;
        int n2 = string.getCol() - cellReference.getCol() + 1;
        return this.readData(sheet, cellReference.getRow(), cellReference.getCol(), n, n2, bl, dataTypeArray, bl2, string2, bl3, nArray);
    }

    public final void writeWorksheet(DataFrame dataFrame, int n, int n2, int n3, boolean bl) {
        Sheet sheet = this.workbook.getSheetAt(n);
        this.writeData(dataFrame, sheet, n2, n3, bl);
    }

    public final void writeWorksheet(DataFrame data, String worksheetName, int startRow, int startCol, boolean header) {
        this.writeWorksheet(data, this.workbook.getSheetIndex(worksheetName), startRow, startCol, header);
    }

    public final void writeWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        this.writeWorksheet(data, worksheetIndex, 0, 0, header);
    }

    public final void writeWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.writeWorksheet(data, worksheetName, 0, 0, header);
    }

    public final DataFrame readWorksheet(int n, int n2, int n3, int n4, int n5, boolean bl, DataType[] dataTypeArray, boolean bl2, String string, boolean bl3, int[] nArray, boolean bl4, boolean bl5) {
        Sheet sheet = this.workbook.getSheetAt(n);
        int[] nArray2 = this.getBoundingBox(n, n2, n3, n4, n5, bl4, bl5);
        n2 = nArray2[0];
        n3 = nArray2[1];
        n4 = nArray2[2];
        n5 = nArray2[3];
        int n6 = n2 < 0 ? 0 : n4 - n2 + 1;
        int n7 = n4 = n3 < 0 ? 0 : n5 - n3 + 1;
        if (n6 == 0 || n4 == 0) {
            this.addWarning("Data frame contains " + n6 + " rows and " + n4 + " columns!");
        }
        return this.readData(sheet, n2, n3, n6, n4, bl, dataTypeArray, bl2, string, bl3, nArray);
    }

    public final DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, boolean autofitRow, boolean autofitCol) {
        return this.readWorksheet(this.workbook.getSheetIndex(worksheetName), startRow, startCol, endRow, endCol, header, colTypes, forceConversion, dateTimeFormat, takeCached, subset, autofitRow, autofitCol);
    }

    /*
     * Unable to fully structure code
     */
    public final void addImage(String var1_1, String var2_2, boolean var3_3) throws FileNotFoundException, IOException {
        block16: {
            block15: {
                var1_1 = new File((String)var1_1);
                var2_2 = this.getName(var2_2);
                var4_4 = this.workbook.getSheet(var2_2.getSheetName());
                var2_2 = new AreaReference(var2_2.getRefersToFormula());
                var5_5 = var2_2.getFirstCell();
                var2_2 = var2_2.getLastCell();
                var6_6 = var1_1.getName().toLowerCase();
                if (var6_6.endsWith("jpg") || var6_6.endsWith("jpeg")) {
                    var6_7 = 5;
                } else if (var6_6.endsWith("png")) {
                    var6_7 = 6;
                } else if (var6_6.endsWith("wmf")) {
                    var6_7 = 3;
                } else if (var6_6.endsWith("emf")) {
                    var6_7 = 2;
                } else if (var6_6.endsWith("bmp") || var6_6.endsWith("dib")) {
                    var6_7 = 7;
                } else if (var6_6.endsWith("pict") || var6_6.endsWith("pct") || var6_6.endsWith("pic")) {
                    var6_7 = 4;
                } else {
                    throw new IllegalArgumentException("Image type \"" + var6_6.substring(var6_6.lastIndexOf(46) + 1) + "\" not supported!");
                }
                var1_1 = new FileInputStream((File)var1_1);
                var7_8 = IOUtils.toByteArray((InputStream)var1_1);
                var6_7 = this.workbook.addPicture(var7_8, var6_7);
                var1_1.close();
                if (!(this.workbook instanceof HSSFWorkbook)) break block15;
                var1_1 = ((HSSFSheet)var4_4).getDrawingPatriarch();
                if (var1_1 != null) break block16;
                ** GOTO lbl-1000
            }
            if (this.workbook instanceof XSSFWorkbook) {
                var1_1 = ((XSSFSheet)var4_4).createDrawingPatriarch();
            } else lbl-1000:
            // 2 sources

            {
                var1_1 = var4_4.createDrawingPatriarch();
            }
        }
        this = this.workbook.getCreationHelper().createClientAnchor();
        this.setRow1(var5_5.getRow());
        this.setCol1(var5_5.getCol());
        this.setRow2(var2_2.getRow() + 1);
        this.setCol2(var2_2.getCol() + 1);
        this.setAnchorType(3);
        this = var1_1.createPicture((ClientAnchor)this, var6_7);
        if (var3_3) {
            this.resize();
        }
    }

    public final CellStyle createCellStyle(String string) {
        if (workbook.getCellStyle(string) == null) {
            Workbook workbook;
            if (workbook.workbook instanceof HSSFWorkbook) {
                workbook = (HSSFWorkbook)workbook.workbook;
                HSSFCellStyle hSSFCellStyle = workbook.createCellStyle();
                if (string != null) {
                    hSSFCellStyle.setUserStyleName(string);
                }
                return new HCellStyle((HSSFWorkbook)workbook, hSSFCellStyle);
            }
            if (workbook.workbook instanceof XSSFWorkbook) {
                workbook = (XSSFWorkbook)workbook.workbook;
                int n = 0;
                CTXf cTXf = CTXf.Factory.newInstance();
                cTXf.setNumFmtId(0L);
                cTXf.setFontId(0L);
                cTXf.setFillId(0L);
                cTXf.setBorderId(0L);
                if (string != null) {
                    CTCellStyles cTCellStyles = workbook.getStylesSource().getCTStylesheet().getCellStyles();
                    if (cTCellStyles == null) {
                        cTCellStyles = workbook.getStylesSource().getCTStylesheet().addNewCellStyles();
                        cTCellStyles.setCount(0L);
                    }
                    if (cTCellStyles.getCount() == 0L) {
                        CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                        cTCellStyle.setName("Standard");
                        cTCellStyle.setXfId(0L);
                        cTCellStyle.setBuiltinId(0L);
                        cTCellStyles.setCount(1L);
                    }
                    CTXf cTXf2 = CTXf.Factory.newInstance();
                    cTXf2.setNumFmtId(0L);
                    cTXf2.setFontId(0L);
                    cTXf2.setFillId(0L);
                    cTXf2.setBorderId(0L);
                    n = workbook.getStylesSource().putCellStyleXf(cTXf2);
                    cTXf.setXfId((long)(n - 1));
                    CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                    cTCellStyle.setName(string);
                    cTCellStyle.setXfId((long)(n - 1));
                    cTCellStyles.setCount(cTCellStyles.getCount() + 1L);
                }
                int n2 = workbook.getStylesSource().putCellXf(cTXf);
                return new XCellStyle((XSSFWorkbook)workbook, n2 - 1, n - 1);
            }
            return null;
        }
        throw new IllegalArgumentException("Cell style with name '" + string + "' already exists!");
    }

    public final CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public final int getActiveSheetIndex() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return -1;
        }
        return this.workbook.getActiveSheetIndex();
    }

    public final String getActiveSheetName() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return null;
        }
        return this.workbook.getSheetName(this.workbook.getActiveSheetIndex());
    }

    public final void setActiveSheet(int sheetIndex) {
        this.workbook.setActiveSheet(sheetIndex);
    }

    public final void setActiveSheet(String sheetName) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.setActiveSheet(sheetIndex);
    }

    public final void hideSheet(int sheetIndex, boolean veryHidden) {
        this.setAlternativeActiveSheet(sheetIndex);
        this.workbook.setSheetHidden(sheetIndex, veryHidden ? 2 : 1);
    }

    public final void hideSheet(String sheetName, boolean veryHidden) {
        this.hideSheet(this.workbook.getSheetIndex(sheetName), veryHidden);
    }

    public final void unhideSheet(int sheetIndex) {
        this.workbook.setSheetHidden(sheetIndex, 0);
    }

    public final void unhideSheet(String sheetName) {
        this.unhideSheet(this.workbook.getSheetIndex(sheetName));
    }

    public final boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public final boolean isSheetHidden(String sheetName) {
        return this.isSheetHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public final boolean isSheetVeryHidden(String sheetName) {
        return this.isSheetVeryHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final void setColumnWidth(int n, int n2, int n3) {
        Workbook workbook = workbook.getSheet(n);
        if (n3 >= 0) {
            workbook.setColumnWidth(n2, n3);
            return;
        }
        if (n3 == -1) {
            workbook.autoSizeColumn(n2);
            return;
        }
        workbook.setColumnWidth(n2, workbook.getDefaultColumnWidth() << 8);
    }

    public final void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.setColumnWidth(this.workbook.getSheetIndex(sheetName), columnIndex, width);
    }

    public final void setRowHeight(int n, int n2, float f) {
        Sheet sheet = this.getSheet(n);
        Row row = sheet.getRow(n2);
        if (row == null) {
            row = this.getSheet(n).createRow(n2);
        }
        if (f >= 0.0f) {
            row.setHeightInPoints(f);
            return;
        }
        row.setHeightInPoints(sheet.getDefaultRowHeightInPoints());
    }

    public final void setRowHeight(String sheetName, int rowIndex, float height) {
        this.setRowHeight(this.workbook.getSheetIndex(sheetName), rowIndex, height);
    }

    private void save(File f) throws FileNotFoundException, IOException {
        this.excelFile = f;
        FileOutputStream fos = new FileOutputStream(f, false);
        this.workbook.write((OutputStream)fos);
        fos.close();
    }

    public final void save(String file) throws FileNotFoundException, IOException {
        this.save(new File(file));
    }

    public final void save() throws FileNotFoundException, IOException {
        this.save(this.excelFile);
    }

    private Name getName(String name) {
        Workbook cname = this.workbook.getName(name);
        if (cname != null) {
            return cname;
        }
        throw new IllegalArgumentException("Name '" + name + "' does not exist!");
    }

    private static boolean isValidReference(String string) {
        return string != null && !string.startsWith("#REF!") && !string.startsWith("#NULL!");
    }

    private void checkName(Name name) {
        if (!Workbook.isValidReference(name.getRefersToFormula())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' has invalid reference!");
        }
        if (!this.existsSheet(name.getSheetName())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' does not refer to a valid sheet!");
        }
    }

    private static Cell getCell(Sheet sheet, int n, int n2, boolean bl) {
        Row row = sheet.getRow(n);
        if (row == null) {
            if (bl) {
                row = sheet.createRow(n);
            } else {
                return null;
            }
        }
        if ((sheet = row.getCell(n2)) == null) {
            if (bl) {
                sheet = row.createCell(n2);
            } else {
                return null;
            }
        }
        return sheet;
    }

    private Sheet getSheet(int n) {
        if (n < 0 || n >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Sheet with index " + n + " does not exist!");
        }
        return this.workbook.getSheetAt(n);
    }

    private Sheet getSheet(String string) {
        Workbook workbook = workbook.workbook.getSheet(string);
        if (workbook == null) {
            throw new IllegalArgumentException("Sheet with name '" + string + "' does not exist!");
        }
        return workbook;
    }

    public final void setMissingValue(Object[] values) {
        this.missingValue = values;
    }

    private void setMissing(Cell cell) {
        if (this.missingValue.length < 1 || this.missingValue[0] == null) {
            cell.setCellType(3);
            return;
        }
        if (this.missingValue[0] instanceof String) {
            cell.setCellValue((String)this.missingValue[0]);
        } else if (this.missingValue[0] instanceof Double) {
            cell.setCellValue(((Double)this.missingValue[0]).doubleValue());
        } else {
            cell.setCellType(3);
            return;
        }
        cell.setCellType(1);
        this.setCellStyle(cell, (CellStyle)DataFormatOnlyCellStyle.get());
    }

    private void setAlternativeActiveSheet(int n) {
        if (n == this.getActiveSheetIndex()) {
            boolean bl = false;
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                if (i == n || this.workbook.isSheetHidden(i) || this.workbook.isSheetVeryHidden(i)) continue;
                this.setActiveSheet(i);
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Cannot hide or remove sheet as there would be no alternative active sheet left!");
            }
        }
    }

    public final CellStyle getCellStyle(String string) {
        Workbook workbook;
        if (workbook.workbook instanceof HSSFWorkbook) {
            workbook = (HSSFWorkbook)workbook.workbook;
            HSSFWorkbook hSSFWorkbook = workbook;
            for (short s = 0; s < workbook.getNumCellStyles(); s = (short)(s + 1)) {
                HSSFCellStyle hSSFCellStyle = hSSFWorkbook.getCellStyleAt(s);
                if (hSSFCellStyle.getUserStyleName() == null || !hSSFCellStyle.getUserStyleName().equals(string)) continue;
                return new HCellStyle((HSSFWorkbook)workbook, hSSFCellStyle);
            }
            return null;
        }
        if (workbook.workbook instanceof XSSFWorkbook) {
            workbook = (XSSFWorkbook)workbook.workbook;
            CTCellStyles cTCellStyles = workbook.getStylesSource().getCTStylesheet().getCellStyles();
            if (cTCellStyles != null) {
                int n = 0;
                while ((long)n < cTCellStyles.getCount()) {
                    CTCellStyle cTCellStyle = cTCellStyles.getCellStyleArray(n);
                    if (cTCellStyle.getName().equals(string)) {
                        int n2 = (int)cTCellStyle.getXfId();
                        return new XCellStyle((XSSFWorkbook)workbook, -1, n2);
                    }
                    ++n;
                }
            }
            return null;
        }
        return null;
    }

    private CellStyle getCellStyle(Cell cell) {
        return new SSCellStyle(this.workbook, cell.getCellStyle());
    }

    private void setCellStyle(Cell cell, CellStyle cellStyle) {
        if (cellStyle != null) {
            if (cellStyle instanceof HCellStyle) {
                HCellStyle.set((HSSFCell)cell, (HCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof XCellStyle) {
                XCellStyle.set((XSSFCell)cell, (XCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof DataFormatOnlyCellStyle) {
                cellStyle = this.getCellStyle(cell);
                switch (cell.getCellType()) {
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
                            break;
                        }
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Numeric));
                        break;
                    }
                    case 1: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
                        break;
                    }
                    case 4: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Boolean));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected cell type detected!");
                    }
                }
                SSCellStyle.set(cell, (SSCellStyle)cellStyle);
                return;
            }
            SSCellStyle.set(cell, (SSCellStyle)cellStyle);
        }
    }

    public final void setCellStyle(String cellReferenceArray, CellStyle cellStyle) {
        String string = (cellReferenceArray = new AreaReference((String)cellReferenceArray)).getFirstCell().getSheetName();
        if (string == null) {
            throw new IllegalArgumentException("Invalid formula reference - should be of the form Sheet!A1:B10");
        }
        string = this.getSheet(string);
        for (CellReference cellReference : cellReferenceArray.getAllReferencedCells()) {
            short s = cellReference.getCol();
            int n = cellReference.getRow();
            cellReference = Workbook.getCell((Sheet)string, n, s, true);
            this.setCellStyle((Cell)cellReference, cellStyle);
        }
    }

    public final void setCellStyle(int n, int n2, int n3, CellStyle cellStyle) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        Cell cell = Workbook.getCell(sheet, n3, n, true);
        this.setCellStyle(cell, cellStyle);
    }

    public final void setCellStyle(String string, int n, int n2, CellStyle cellStyle) {
        int n3 = n2;
        n2 = n;
        Cell cell = Workbook.getCell(this.getSheet(string), n2, n3, true);
        this.setCellStyle(cell, cellStyle);
    }

    public final void mergeCells(int n, String string) {
        this.getSheet(n).addMergedRegion(CellRangeAddress.valueOf((String)string));
    }

    public final void mergeCells(String string, String string2) {
        this.getSheet(string).addMergedRegion(CellRangeAddress.valueOf((String)string2));
    }

    public final void unmergeCells(int n, String string) {
        Workbook workbook = workbook.getSheet(n);
        for (n = 0; n < workbook.getNumMergedRegions(); ++n) {
            if (!workbook.getMergedRegion(n).formatAsString().equals(string)) continue;
            workbook.removeMergedRegion(n);
            return;
        }
    }

    public final void unmergeCells(String sheetName, String reference) {
        this.unmergeCells(this.workbook.getSheetIndex(sheetName), reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Workbook getWorkbook(String object, boolean bl) throws FileNotFoundException, IOException, InvalidFormatException {
        if (((File)(object = new File((String)object))).exists()) {
            return new Workbook((File)object);
        }
        if (!bl) throw new FileNotFoundException("File '" + ((File)object).getName() + "' could not be found - " + "you may specify to automatically create the file if not existing.");
        String string = ((File)object).getName().toLowerCase();
        if (string.endsWith(".xls")) {
            return new Workbook((File)object, SpreadsheetVersion.EXCEL97);
        }
        if (!string.endsWith(".xlsx")) throw new IllegalArgumentException("File extension \"" + string.substring(string.lastIndexOf(46) + 1) + "\" not supported! Only *.xls and *.xlsx are allowed!");
        return new Workbook((File)object, SpreadsheetVersion.EXCEL2007);
    }

    public final void setCellFormula(int n, int n2, int n3, String string) {
        Workbook.getCell(this.getSheet(n), n2, n3, true).setCellFormula(string);
    }

    public final void setCellFormula(String string, int n, int n2, String string2) {
        Workbook.getCell(this.getSheet(string), n, n2, true).setCellFormula(string2);
    }

    public final String getCellFormula(int n, int n2, int n3) {
        return Workbook.getCell(this.getSheet(n), n2, n3, true).getCellFormula();
    }

    public final String getCellFormula(String string, int n, int n2) {
        return Workbook.getCell(this.getSheet(string), n, n2, true).getCellFormula();
    }

    public final boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.getSheet(sheetIndex).getForceFormulaRecalculation();
    }

    public final boolean getForceFormulaRecalculation(String sheetName) {
        return this.getSheet(sheetName).getForceFormulaRecalculation();
    }

    public final void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.getSheet(sheetIndex).setForceFormulaRecalculation(value);
    }

    public final void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.getSheet(sheetName).setForceFormulaRecalculation(value);
    }

    public final void setAutoFilter(int n, String string) {
        this.getSheet(n).setAutoFilter(CellRangeAddress.valueOf((String)string));
    }

    public final void setAutoFilter(String string, String string2) {
        this.getSheet(string).setAutoFilter(CellRangeAddress.valueOf((String)string2));
    }

    public final int getLastRow(int sheetIndex) {
        return this.getSheet(sheetIndex).getLastRowNum();
    }

    public final int getLastRow(String sheetName) {
        return this.getSheet(sheetName).getLastRowNum();
    }

    private static int getLastColumn(Sheet sheet) {
        int n = sheet.getLastRowNum();
        short s = 1;
        for (int i = 0; i < n; ++i) {
            short s2;
            Row row = sheet.getRow(i);
            if (row == null || (s2 = row.getLastCellNum()) <= s) continue;
            s = s2;
        }
        return s - 1;
    }

    public final int getLastColumn(int n) {
        return Workbook.getLastColumn(this.getSheet(n));
    }

    public final int getLastColumn(String string) {
        return Workbook.getLastColumn(this.getSheet(string));
    }

    public final void appendNamedRegion(DataFrame dataFrame, String string, boolean bl) {
        Sheet sheet = this.workbook.getSheet(this.getName(string).getSheetName());
        int[] nArray = this.getReferenceCoordinates(string);
        this.writeData(dataFrame, sheet, nArray[2] + 1, nArray[1], bl);
        int n = nArray[2] + dataFrame.rows();
        int n2 = Math.max(nArray[1] + dataFrame.columns() - 1, nArray[3]);
        String string2 = new CellRangeAddress(nArray[0], n, nArray[1], n2).formatAsString(sheet.getSheetName(), true);
        this.createName(string, string2, true);
    }

    public final void appendWorksheet(DataFrame dataFrame, int n, boolean bl) {
        int n2;
        short s;
        Sheet sheet = this.getSheet(n);
        int n22 = this.getLastRow(n);
        int s2 = Integer.MAX_VALUE;
        for (int i = 0; i < n22 && s > 0; ++i) {
            Row row = sheet.getRow(i);
            if (row == null || row.getFirstCellNum() >= s) continue;
            s = row.getFirstCellNum();
        }
        if (s == Integer.MAX_VALUE) {
            n2 = 0;
        }
        this.writeWorksheet(dataFrame, n, this.getLastRow(n) + 1, n2, bl);
    }

    public final void appendWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.appendWorksheet(data, this.workbook.getSheetIndex(worksheetName), header);
    }

    public final void clearSheet(int n) {
        Workbook workbook = workbook.getSheet(n);
        n = workbook.getFirstRowNum();
        for (int i = workbook.getLastRowNum(); i >= n; --i) {
            Row row = workbook.getRow(i);
            if (row == null) continue;
            workbook.removeRow(row);
        }
    }

    public final void clearSheet(String sheetName) {
        this.clearSheet(this.workbook.getSheetIndex(sheetName));
    }

    public final void clearRange(int n, int[] nArray) {
        Workbook workbook = workbook.getSheet(n);
        for (n = nArray[0]; n <= nArray[2]; ++n) {
            Row row = workbook.getRow(n);
            if (row == null) continue;
            for (int i = nArray[1]; i <= nArray[3]; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                row.removeCell(cell);
            }
            if (row.getLastCellNum() >= 0) continue;
            workbook.removeRow(row);
        }
    }

    public final void clearRange(String sheetName, int[] coords) {
        this.clearRange(this.workbook.getSheetIndex(sheetName), coords);
    }

    public final void clearRangeFromReference(String object) {
        object = new AreaReference((String)object);
        CellReference cellReference = object.getFirstCell();
        object = object.getLastCell();
        String string = cellReference.getSheetName();
        object = new int[]{cellReference.getRow(), cellReference.getCol(), object.getRow(), object.getCol()};
        this.clearRange(string, (int[])object);
    }

    public final void clearNamedRegion(String name) {
        String sheetName = this.getName(name).getSheetName();
        int[] coords = this.getReferenceCoordinates(name);
        this.clearRange(sheetName, coords);
    }

    public final void createFreezePane(int n, int n2, int n3, int n4, int n5) {
        if (n4 < 0 | n5 < 0) {
            this.getSheet(n).createFreezePane(n2, n3);
            return;
        }
        this.getSheet(n).createFreezePane(n2, n3, n4, n5);
    }

    public final void createFreezePane(String sheetName, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.createFreezePane(this.workbook.getSheetIndex(sheetName), colSplit, rowSplit, leftColumn, topRow);
    }

    public final void createFreezePane(int sheetIndex, int colSplit, int rowSplit) {
        this.createFreezePane(sheetIndex, colSplit, rowSplit, -1, -1);
    }

    public final void createFreezePane(String sheetName, int colSplit, int rowSplit) {
        this.createFreezePane(sheetName, colSplit, rowSplit, -1, -1);
    }

    public final void createSplitPane(int sheetIndex, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.getSheet(sheetIndex).createSplitPane(xSplitPos, ySplitPos, leftColumn, topRow, 0);
    }

    public final void createSplitPane(String sheetName, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.createSplitPane(this.workbook.getSheetIndex(sheetName), xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public final void removePane(int sheetIndex) {
        this.createFreezePane(sheetIndex, 0, 0);
    }

    public final void removePane(String sheetName) {
        this.createFreezePane(sheetName, 0, 0);
    }

    public final void setSheetColor(int n, int n2) {
        if (this.workbook instanceof XSSFWorkbook) {
            ((XSSFSheet)this.workbook.getSheetAt(n)).setTabColor(n2);
        }
    }

    public final void setSheetColor(String string, int n) {
        if (this.workbook instanceof XSSFWorkbook) {
            ((XSSFSheet)this.workbook.getSheet(string)).setTabColor(n);
            return;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            this.addWarning("Setting the sheet color for XLS files is not supported yet.");
        }
    }

    public final int[] getBoundingBox(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        Workbook workbook = workbook.workbook.getSheetAt(n);
        if (n2 < 0 && workbook.getRow(n2 = workbook.getFirstRowNum()) == null) {
            n2 = -1;
        }
        if (n4 < 0 && workbook.getRow(n4 = workbook.getLastRowNum()) == null) {
            n4 = -1;
        }
        int n6 = n4;
        int n7 = n3;
        int n8 = n5 < 0 ? 0x7FFFFFFE : n5;
        n3 = n3 < 0 ? 0x7FFFFFFE : n3;
        n5 = n5 < 0 ? -1 : n5;
        Cell cell = null;
        Cell cell2 = null;
        boolean bl3 = false;
        for (n = n2; n > -1 && n <= n6; ++n) {
            Row row = workbook.getRow(n);
            if (row == null) continue;
            int n9 = Math.min(n8 + 1, row.getLastCellNum());
            boolean bl4 = false;
            for (int i = Math.max(n7, row.getFirstCellNum()); i > -1 && i < n9; ++i) {
                Cell cell3 = row.getCell(i);
                if (cell3 == null || cell3.getCellType() == 3) continue;
                bl3 = true;
                bl4 = true;
                if (!(!bl2 && n7 >= 0 || cell != null && i >= n3)) {
                    n3 = i;
                    cell = cell3;
                }
                if (!bl2 && n8 != 0x7FFFFFFE || cell2 != null && i <= n5) continue;
                n5 = i;
                cell2 = cell3;
            }
            if (!bl || !bl4) continue;
            n4 = n;
            if (workbook.getRow(n2) != null) continue;
            n2 = n;
        }
        if ((bl || n2 < 0) && !bl3) {
            n4 = -1;
            n2 = -1;
        }
        if ((bl2 || n3 == 0x7FFFFFFE) && !bl3) {
            n5 = -1;
            n3 = -1;
        }
        return new int[]{n2, n3, n4, n5};
    }

    public final int[] getBoundingBox(String sheetName, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitColumn) {
        return this.getBoundingBox(this.workbook.getSheetIndex(sheetName), startRow, startCol, endRow, endCol, autofitRow, autofitColumn);
    }
}

