/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.util.CellReference;

public abstract class CellUtils {
    public static String formatAsString(Cell cell) {
        return new CellReference(cell).formatAsString();
    }

    public static String getErrorMessage(byte by) {
        FormulaError formulaError = FormulaError.forInt((byte)by);
        switch (formulaError) {
            case DIV0: {
                return "Division by 0";
            }
            case NA: {
                return "Value is not available";
            }
            case NAME: {
                return "No such name defined";
            }
            case NULL: {
                return "Two areas are required to intersect but do not";
            }
            case NUM: {
                return "Value outside of domain";
            }
            case REF: {
                return "Invalid cell reference";
            }
            case VALUE: {
                return "Incompatible type";
            }
        }
        return "Unknown error";
    }
}

