% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplot.R
\name{xplot}
\alias{xplot}
\title{xplot}
\usage{
xplot(locations, localPath = tempdir())
}
\arguments{
\item{locations}{A \code{data.frame} object with locations data.}

\item{localPath}{Path to store the images. Default: \code{tempdir()}}
}
\value{
It returns a \code{ggplot} object and exports a \code{.jpeg} image with
the locations map. Images will be saved under a new directory, called
\code{POLARISOut}. The directory will be created within the \code{localPath}
and used to store the raster images from the POLARIS database.
}
\description{
Identifies images containing the locations.
}
\details{
This function is useful for checking if locations were correctly
informed, but its output is not required by \code{ximages} or \code{xsoil}. If a
given location falls in the border of an image (round coordinates),
the function will make sure a minimum number of images is downloaded.
}
\examples{
\dontrun{
df_test <- exkansas
xplot(locations = df_test)
}
}
\seealso{
\code{\link[XPolaris]{ximages}},\code{\link[XPolaris]{xsoil}}
}
