% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/pythonInterface.R
\name{functions}
\alias{functions}
\alias{pythonCall}
\alias{pythonCommand}
\alias{pythonDefine}
\alias{pythonEval}
\alias{pythonGet}
\alias{pythonName}
\alias{pythonSend}
\alias{pythonSerialize}
\alias{pythonShell}
\alias{pythonSource}
\alias{pythonUnserialize}
\title{Function Versions of Methods for Python Interface evaluators.}
\usage{
pythonSend(object, evaluator = XR::getInterface(.PythonInterfaceClass))

pythonEval(expr, ..., evaluator = XR::getInterface(.PythonInterfaceClass))

pythonCommand(expr, ..., evaluator = XR::getInterface(.PythonInterfaceClass))

pythonCall(fun, ..., evaluator = XR::getInterface(.PythonInterfaceClass))

pythonGet(object, evaluator = XR::getInterface(.PythonInterfaceClass))

pythonSource(file, ..., evaluator = XR::getInterface(.PythonInterfaceClass))

pythonDefine(text, file, ...,
  evaluator = XR::getInterface(.PythonInterfaceClass))

pythonSerialize(object, file, append = FALSE,
  evaluator = XR::getInterface(.PythonInterfaceClass))

pythonUnserialize(file, all = FALSE,
  evaluator = XR::getInterface(.PythonInterfaceClass))

pythonName(object)

pythonShell(..., evaluator = XR::getInterface(.PythonInterfaceClass))
}
\arguments{
\item{object}{For \code{pythonSend()}, an R object, to be sent to Python.  For \code{pythonGet()},
\code{pythonSerialize()} and \code{pythonNqme()}, a proxy object for
a Python object.}

\item{evaluator}{The evaluator object to use.  By default, and usually, the current evaluator
is used, and one is started if none has been.}

\item{expr}{A string for a Python expression or command, with C-style fields (\code{"\%s"}) to be substituted for the following arguments, if any.}

\item{...}{For the evaluation functions: Objects, either R objects to be converted or proxies for Python objects previously computed.
For other functions, specialized arguments for the corresponding method.
In particular, \code{.get=} for controlling whether the computed result should be converted.}

\item{fun}{the string name of the function; a module name must be included in the string if the function has
not been explicitly imported from that module.}

\item{file}{A filename or an open connection, for reading or writing depending on the function}

\item{text}{the definition as text (supply argument  file= instead  to read it from a file)}

\item{append}{should the serializing text be appended to a file; otherwise the file will be truncated on opening.}

\item{all}{should the unserialized object be a list of all serialized objects on the file?}
}
\description{
These functions allow application code to invoke evaluator methods for essentially all basic computations.   Usually, they access
the current Python evaluator, starting one if none exists.  For details, see the documentation for the corresponding method, under
\link{PythonInterface}.
}
\section{Functions}{
\itemize{
\item \code{pythonSend}: sends the \code{object} to Python, converting it via methods for
\code{\link[XR]{asServerObject}} and returns a proxy for the converted object.

\item \code{pythonEval}: evaluates the \code{expr} string subsituting the arguments.

\item \code{pythonCommand}: evaluates the \code{expr} string subsituting the arguments; used for a command that is not
an expression.

\item \code{pythonCall}: call the function in Python, with arguments given.

\item \code{pythonGet}: converts the proxy object that is its argument to an \R{} object.

\item \code{pythonSource}: evaluate the file of Python source.

\item \code{pythonDefine}: define a Python function

\item \code{pythonSerialize}: serialize the \code{object} in Python, via \code{pickle}

\item \code{pythonUnserialize}: unserialize the file in Python, via \code{pickle}

\item \code{pythonName}: return the name by which this proxy object was assigned in Python

\item \code{pythonShell}: Start an interactive Python shell.  See the chapter file in the documentation, section 14.3.
}}

