% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motzkin.R
\name{Motzkin}
\alias{Motzkin}
\alias{A001006}
\title{Motzkin numbers}
\usage{
Motzkin(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A001006}{A001006}, a \emph{Motzkin} number for a given \emph{n} is the number
of ways for drawing non-intersecting chords among \emph{n} points on a circle,
where the first 7 entries are 1, 1, 2, 4, 9, 21, 51.
}
\examples{
## generate first 30 Motzkin numbers
first30 = Motzkin(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
