% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_QSM.R
\name{read_QSM}
\alias{read_QSM}
\title{Read a QSM}
\usage{
read_QSM(file, model)
}
\arguments{
\item{file}{The directory to the QSM file path}

\item{model}{\code{treeQSM}, \code{simpletree}, \code{simpleforest} or \code{pypetree} depending on the algorithm used to generate the QSM}
}
\value{
a list containing a data.table with the QSM and a character with the model name. This list can be used to build an aRchi object (see function \code{\link{build_aRchi}})
}
\description{
Read a QSM file generated with treeQSM, simpletree, simpleforest or pypetree.
}
\details{
For \code{treeQSM} model, please respect the format with column order provided in the last version <https://github.com/InverseTampere/TreeQSM/blob/master/README.md>
}
\examples{
file=system.file("extdata","Tree_1_TreeQSM.txt",package = "aRchi")
QSM=read_QSM(file,model="treeQSM")
}
\seealso{
\code{\link{aRchi}} the aRchi class;\code{\link{build_aRchi}} to build an object of class \code{aRchi}
}
