% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorPalette.R
\name{colorPalette}
\alias{colorPalette}
\title{Color Palette Generator}
\usage{
colorPalette(name, n = NULL)
}
\arguments{
\item{name}{name of the color palette. Can be \code{random} for random colors, \code{complement} for complementing colors, \code{divergent} for equally spaced colors, or \code{random-palette} for a random palette, but can also be the name of a pre-implemented palette. See the \code{details} section for a list of pre-implemented palettes.}

\item{n}{the number of colors to select from the palette. Required if \code{name = 'random'}, \code{name = 'complement'}, or \code{name = 'divergent'}. Otherwise, if \code{NULL}, automatically selects all colors from the chosen palette.}
}
\value{
A vector of colors.
}
\description{
This function creates a random color palette, or allows the user to select a pre-implemented palette.
}
\details{
The following color palettes are implemented:

\if{html}{\figure{colors.svg}{options: width=600 alt="colors"}}
\if{latex}{\figure{colors.pdf}{options: width=5in}}
}
\examples{
colorPalette("divergent", 5)
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{canvas}
\keyword{palette}
