% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.one.R
\docType{class}
\name{VT.forest.one}
\alias{VT.forest.one}
\title{Difft by one random forest}
\description{
A reference class to compute twins via one random forest
}
\details{
\code{VT.forest.one} extends \code{VT.forest}.

OOB predictions are used to estimate \eqn{E(Y|T = real treatment)}. Then, 
treatement is switched, it means that 1 becomes 0 and 0 becomes 1. We use 
again \code{model} to estimate \eqn{E(Y|T = the other treatment)}. This is
what \code{computeTwin1()} and \code{computeTwin2()} functions do.
}
\section{Fields}{

\describe{
\item{\code{model}}{is a caret/RandomForest/randomForest class object}

\item{\code{interactions}}{logical set TRUE if model has been computed with interactions}

\item{\code{...}}{field from parent class : \code{\link{VT.forest}}}
}}
\section{Methods}{

\describe{
\item{\code{computeTwin1()}}{Compute twin1 with OOB predictions}

\item{\code{computeTwin2()}}{Compute twin2 by switching treatment and applying random forest model}
}}
\seealso{
\code{\link{VT.difft}}, \code{\link{VT.forest}}, \code{\link{VT.forest.double}}
}

