% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/processDocument.R
\name{processDocument}
\alias{processDocument}
\title{Process Document}
\usage{
processDocument(taskId = NULL, language = "English",
  profile = "documentConversion", textType = "normal",
  imageSource = "auto", correctOrientation = "true", correctSkew = "true",
  readBarcodes = "false", exportFormat = "txt", description = NULL,
  pdfPassword = NULL)
}
\arguments{
\item{taskId}{- Only tasks with Submitted, Completed or NotEnoughCredits status can be processed using this function.}

\item{language}{Optional; default: English}

\item{profile}{Optional; default: documentConversion}

\item{textType}{Optional; default: normal}

\item{imageSource}{Optional; default: auto}

\item{correctOrientation}{Optional; default: true}

\item{correctSkew}{Optional; default: true}

\item{readBarcodes}{Optional; default:}

\item{exportFormat}{Optional; default: txt}

\item{description}{Optional; default: ""}

\item{pdfPassword}{Optional; default: NULL}
}
\value{
Data frame with details of the task associated with the submitted Document
}
\description{
This function processes several images for the same task and results in a multi-page document.
For instance, upload pages of the book individually via submitImage to the same task. And then process it via ProcessDocument to get a multi-page pdf.
}
\examples{
\dontrun{
processDocument(taskId = "task_id")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/processDocument/}
}

