\name{flux_difference_plotter}
\alias{flux_difference_plotter}
\alias{flux distribution comparisons}
\title{flux_difference_plotter, a function to plot two pre-existing flux distributions obtained using FBA_solve}
\description{
	To analyse the effect of reaction deletions on the fluxome 
	requires a contextual visualization, simple plots give little 
	insight on what the results of the simulation mean. This function 
	uses the annotations inherent to SBML models and generates comparative 
	overlapping fluxome bar graphs depicting the overlap/change in flux 
	based on Sub-system wise classification and generates PDF's for the same. 
	The color scheme is green for wild-type and red for mutant. Overlaps 
	of red and green generate brown while overshot mutant fluxes show 
	up as magenta-pink, also separate PDF's are generated for increased 
	and decreased fluxes.
	}
\usage{
flux_difference_plotter(wt_flux,mut_flux,fba_object,graph_fname)
}
\arguments{
	\item{fba_object}{Is a list containing the data required to perform flux
	balance analysis. The elements of the list are mat which is the 
	stoichiometric matrix, dir which gives the direction of the equality 
	constraints, obj specifies the objective function for the simulation, 
	bounds specifies the lower and upper inequality constraints, rhs is the 
	right hand side of the steady state expression, types refers to the 
	numeric nature of the variables which in case of FBA happens to be 
	"Continuous", max is a Boolean specifying the type of optimization,
	"Maximization" by default, all_genes is all the genes present in the 
	model, gpr contains boolean expressions of gene essentiality for the 
	corresponding reactions in the model, metabolite_name contains list of 
	all the metabolites, reaction_list contains all the reactions present in
	the model, compartment is a numeric identifier for each reaction the key
	for which is in comp_name.
	}
	\item{wt_flux}{A list containing the solution to an FBA problem 
	which is returned by the FBA_solve function. By convention the 
	fluxes in this list represent the Wild-type strain and will 
	appear as green bar plots.}
	\item{mut_flux}{A list containing the solution to an FBA problem 
	which is returned by the FBA_solve function. By convention the 
	fluxes in this list represent the Mutant-type strain and will 
	appear as red bar plots.}	
	\item{graph_fname}{A string to name the output files}
}
\examples{
	# A comparison of two flux distributions generated by FBA_solve
	data(Ecoli_core)
	Ec_Mutant<-Ecoli_core
	#The reaction number for O2 exchange is 36 by setting 
	#the corresponding bounds to zero we make a aerobic 
	#respiration deficient mutant
	
	Ec_Mutant$bounds$lower$val[36]=0
	Ec_Mutant$bounds$upper$val[36]=0
	mut_flux<-FBA_solve(Ec_Mutant)
	wt_flux<-FBA_solve(Ecoli_core)
	flux_difference_plotter(wt_flux,mut_flux,Ecoli_core,graph_fname="Flux_comparison")
	}
