% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_scaling_factor.R
\name{apply_scaling_factor}
\alias{apply_scaling_factor}
\title{Apply the scaling factor R to get the most suitable locus-specific AF threshold.}
\usage{
apply_scaling_factor(tabindex, R = 1, use.optimal.R = FALSE,
  target_size = NA)
}
\arguments{
\item{tabindex}{The data.frame output from the \code{callsnvs} function. (if use.optimal.R = TRUE , tabindex must contain the column "case_mean_coverage"; use get_case_mean_coverage())}

\item{R}{The scaling factor R to adjust the AF threshold. default = 1 (neutral value, no changes)}

\item{use.optimal.R}{Automatically use the best scaling factor R given the mean coverage of the CASE sample and size of targeted regions. default: FALSE}

\item{target_size}{if use.optimal.R = TRUE, target size in Mb of the BED file as provided by the \code{get_target_size} fuction.}
}
\value{
Given the combination of coverage, allelic fraction and pbem, return the most suitable scaling factor R to adjust the AF threshold.
}
\description{
Apply the scaling factor R to get the most suitable locus-specific AF threshold.
}
\examples{
sample.info.file <- system.file("extdata", "test_sif_toy.tsv", package = "abemus")
outdir <- tempdir()
targetbed <- system.file("extdata", "regions_toy.bed", package = "abemus")
pacbamfolder_bychrom <- system.file("extdata", "pacbam_data_bychrom", package = "abemus")
pbem_dir <- system.file("extdata", "BaseErrorModel", package = "abemus")
controls_dir <- system.file("extdata", "Controls", package = "abemus")
m<-callsnvs(sample.info.file,outdir,targetbed,pbem_dir,controls_dir,pacbamfolder_bychrom,replicas=1)
tabindex <- m$tabsnvs_index
tabindex <- get_case_mean_coverage(tabindex = tabindex,pacbamfolder_bychrom = pacbamfolder_bychrom)
m$tabsnvs_index_scalfact <- apply_scaling_factor(tabindex = tabindex)
}
