% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prox_ENbt.R
\name{prox_ENbt}
\alias{prox_ENbt}
\title{Accelerated Proximal Gradient on l1 regularized quadratic program with backtracking}
\usage{
prox_ENbt(A, Xt, Om, gamma, d, x0, lam, L, eta, maxits, tol)
}
\arguments{
\item{A}{p by p positive definite coefficient matrix
\deqn{A = (\gamma Om + X^T X/n)}{A = (gamma Om + X^T X/n)}.}

\item{Xt}{Same as X above, we need it to make calculations faster.}

\item{Om}{Same reason as for the above parameter.}

\item{gamma}{l2 regularizing parameter.}

\item{d}{nx1 dimensional column vector.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{L}{Initial value of backtracking Lipshitz constant.}

\item{eta}{Backtracking scaling parameter.}

\item{maxits}{Number of iterations to run}

\item{tol}{Stopping tolerance for proximal gradient algorithm.}
}
\value{
\code{prox_ENbt} returns an object of \code{\link{class}} "\code{prox_ENbt}" including a list
with the following named components

\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{x}}{Found solution.}
  \item{\code{k}}{Number of iterations used.}
}
}
\description{
Applies accelerated proximal gradient (with backtracking) algorithm to the l1-regularized quadratic program
\deqn{f(\mathbf{x}) + g(\mathbf{x}) = \frac{1}{2}\mathbf{x}^TA\mathbf{x} - d^T\mathbf{x} + \lambda |\mathbf{x}|_1}{f(x) + g(x) = 0.5*x^T*A*x - d^T*x + lambda*|x|_l1}
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Used by: \code{\link{SDAP}} and the \code{SDAPcv} cross-validation version.
}
\keyword{internal}
