% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_figures.R
\name{ext_img}
\alias{ext_img}
\title{External images for Word output}
\usage{
ext_img(src, width = 0.5, height = 0.2, alt = "", ref_docx_dim)
}
\arguments{
\item{src}{image file path}

\item{width}{width in inches}

\item{height}{height in inches}

\item{alt}{alternative text for images}

\item{ref_docx_dim}{A list containing the components \code{page} (a named
numeric vector containing the \code{width} and \code{height}),
\code{landscape} (a logical vector) and \code{margins} (a named numeric
vector containing the \code{top}, \code{bottom}, \code{left},
\code{right}, \code{header} and \code{footer} margins). See
\strong{Details}.}
}
\value{
An object of class \code{c("external_img", "cot", "run")} with
attributes \code{"dims"} (a named list containing the figure's
\code{width} and \code{height}) and \code{"alt"} (a character scalar
containing the alternative text for the figure).
}
\description{
This is a modified version of the \code{\link[officer]{external_img}}
function from the \code{officer} package for use in \code{\link{rmd2word}}.
The modification is to allow the use of the \code{\link[knitr]{knitr}} chunk
options \code{out.width} and/or \code{out.height} to set the dimensions of a
figure (R-generated or external image) when the output format is a Word
document. This functionality is not normally available.
}
\details{
If in the current R code chunk \code{out.width} or
\code{out.height} have been set then the corresponding values of
\code{fig.width} and \code{fig.height} are inferred from the dimensions
of the figure and the page dimensions of the output Word document.
The former are obtained using \code{\link[png]{readPNG}} or
\code{\link[jpeg]{readJPEG}} as appropriate.  If only one of
\code{out.width} or \code{out.height} are set then the aspect ratio of the
figure is preserved.

\code{ref_docx_dim} can be produced using
\code{officer::docx_dim(officer::read_docx(doc))}, where \code{doc} is an
\code{\link[officer]{docx_dim}} object and \code{\link[officer]{docx_dim}}
and \code{\link[officer]{read_docx}} are functions in the \code{officer}
package.
}
\note{
This function has been designed for use inside \code{\link{rmd2word}}
but the object returned has the same structure as that returned from
\code{\link[officer]{external_img}}. Outside the context of a
\code{knitr} R code chunk the outputs from \code{external_img} and
\code{ext_img} are identical.
}
\examples{
# Example from the officer::external_img() documentation
# Wrap R logo with external_img ----
srcfile <- file.path( R.home("doc"), "html", "logo.jpg" )
extimg <- ext_img(src = srcfile, height = 1.06 / 2, width = 1.39 / 2)
}
